/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.syncope.client.console.SyncopeWebApplication;
import org.apache.syncope.client.console.panels.BeanPanel;
import org.apache.syncope.client.console.rest.AttrRepoRestClient;
import org.apache.syncope.client.console.wizards.BaseAjaxWizardBuilder;
import org.apache.syncope.client.console.wizards.mapping.AttrRepoMappingPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxNumberFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizard;
import org.apache.syncope.common.lib.attr.AttrRepoConf;
import org.apache.syncope.common.lib.to.AttrRepoTO;
import org.apache.syncope.common.lib.types.AttrRepoState;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.wizard.IWizardStep;
import org.apache.wicket.extensions.wizard.WizardModel;
import org.apache.wicket.extensions.wizard.WizardStep;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.springframework.util.ClassUtils;

public class AttrRepoWizardBuilder
extends BaseAjaxWizardBuilder<AttrRepoTO> {
    private static final long serialVersionUID = -6163230263062920394L;
    protected final LoadableDetachableModel<List<String>> attrRepoConfs;
    protected final AttrRepoRestClient attrRepoRestClient;
    protected final Model<Class<? extends AttrRepoConf>> attrRepoConfClass = Model.of();

    public AttrRepoWizardBuilder(AttrRepoTO defaultItem, AttrRepoRestClient attrRepoRestClient, PageReference pageRef) {
        super((Serializable)defaultItem, pageRef);
        this.attrRepoConfs = new LoadableDetachableModel<List<String>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected List<String> load() {
                return SyncopeWebApplication.get().getLookup().getClasses(AttrRepoConf.class).stream().map(Class::getName).sorted().collect(Collectors.toList());
            }
        };
        this.attrRepoRestClient = attrRepoRestClient;
    }

    protected Serializable onApplyInternal(AttrRepoTO modelObject) {
        if (this.mode == AjaxWizard.Mode.CREATE) {
            this.attrRepoRestClient.create(modelObject);
        } else {
            this.attrRepoRestClient.update(modelObject);
        }
        return modelObject;
    }

    protected WizardModel buildModelSteps(AttrRepoTO modelObject, WizardModel wizardModel) {
        wizardModel.add((IWizardStep)new Profile(modelObject, this.attrRepoConfs, this.attrRepoConfClass));
        wizardModel.add((IWizardStep)new Configuration(modelObject));
        wizardModel.add((IWizardStep)new Mapping(modelObject));
        return wizardModel;
    }

    protected static class Profile
    extends WizardStep {
        private static final long serialVersionUID = -3043839139187792810L;

        Profile(final AttrRepoTO attrRepo, LoadableDetachableModel<List<String>> attrRepoConfs, final Model<Class<? extends AttrRepoConf>> attrRepoConfClass) {
            boolean isNew;
            boolean bl = isNew = attrRepo.getConf() == null;
            if (!isNew) {
                attrRepoConfClass.setObject((Serializable)attrRepo.getConf().getClass());
            }
            AjaxTextFieldPanel key = new AjaxTextFieldPanel("key", "key", (IModel)new PropertyModel((Object)attrRepo, "key"));
            key.addRequiredLabel();
            key.setEnabled(isNew);
            this.add(new Component[]{key});
            AjaxTextFieldPanel description = new AjaxTextFieldPanel("description", this.getString("description"), (IModel)new PropertyModel((Object)attrRepo, "description"));
            this.add(new Component[]{description});
            AjaxDropDownChoicePanel state = new AjaxDropDownChoicePanel("state", this.getString("state"), (IModel)new PropertyModel((Object)attrRepo, "state"));
            state.setChoices(List.of(AttrRepoState.values()));
            state.addRequiredLabel();
            state.setNullValid(false);
            this.add(new Component[]{state});
            this.add(new Component[]{new AjaxNumberFieldPanel.Builder().build("order", "order", Integer.class, (IModel)new PropertyModel((Object)attrRepo, "order")).addRequiredLabel()});
            final AjaxDropDownChoicePanel conf = new AjaxDropDownChoicePanel("conf", this.getString("type"), (IModel)(isNew ? Model.of() : Model.of((Serializable)((Object)attrRepo.getConf().getClass().getName()))));
            conf.setChoices((List)attrRepoConfs.getObject());
            conf.addRequiredLabel();
            conf.setNullValid(false);
            conf.setEnabled(isNew);
            conf.add(new Behavior[]{new AjaxEventBehavior("change"){
                private static final long serialVersionUID = -7133385027739964990L;

                protected void onEvent(AjaxRequestTarget target) {
                    try {
                        Class clazz = ClassUtils.resolveClassName((String)((String)((Object)conf.getModelObject())), (ClassLoader)ClassUtils.getDefaultClassLoader());
                        attrRepo.setConf((AttrRepoConf)clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
                        attrRepoConfClass.setObject((Serializable)clazz);
                    }
                    catch (Exception e) {
                        LOG.error("During deserialization", (Throwable)e);
                    }
                }
            }});
            this.add(new Component[]{conf});
        }
    }

    protected class Configuration
    extends WizardStep {
        private static final long serialVersionUID = -785981096328637758L;

        Configuration(AttrRepoTO attrRepo) {
            this.add(new Component[]{new BeanPanel("bean", (IModel)new PropertyModel((Object)attrRepo, "conf"), AttrRepoWizardBuilder.this.pageRef, new String[0]).setRenderBodyOnly(true)});
        }
    }

    protected static final class Mapping
    extends WizardStep {
        private static final long serialVersionUID = 3454904947720856253L;

        Mapping(AttrRepoTO attrRepo) {
            this.setTitleModel((IModel)Model.of((Serializable)((Object)"Mapping")));
            this.setSummaryModel((IModel)Model.of((Serializable)((Object)"")));
            this.add(new Component[]{new AttrRepoMappingPanel("mapping", attrRepo)});
        }
    }
}

