/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.executors;

import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.synapse.commons.executors.Importance;
import org.apache.synapse.commons.executors.InternalQueue;
import org.apache.synapse.commons.executors.NextQueueAlgorithm;
import org.apache.synapse.commons.executors.PRRNextQueueAlgorithm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiPriorityBlockingQueue<E>
extends AbstractQueue<E>
implements BlockingQueue<E> {
    private List<InternalQueue<E>> queues;
    private int count = 0;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition notEmpty = this.lock.newCondition();
    private int capacity = Integer.MAX_VALUE;
    private NextQueueAlgorithm<E> nextQueueAlgorithm;
    private boolean isFixedSizeQueues;

    public MultiPriorityBlockingQueue(List<InternalQueue<E>> queues, boolean isFixedQueues, NextQueueAlgorithm<E> algorithm) {
        this.queues = queues;
        this.isFixedSizeQueues = isFixedQueues;
        this.capacity = Integer.MAX_VALUE;
        if (isFixedQueues) {
            this.capacity = 0;
            for (InternalQueue<InternalQueue<E>> internalQueue : queues) {
                this.capacity += internalQueue.getCapacity();
            }
        }
        Collections.sort(this.queues, new Comparator<InternalQueue<E>>(){

            @Override
            public int compare(InternalQueue<E> o1, InternalQueue<E> o2) {
                return o2.getPriority() - o1.getPriority();
            }
        });
        for (InternalQueue<InternalQueue<E>> internalQueue : this.queues) {
            internalQueue.setNotFullCond(this.lock.newCondition());
        }
        this.nextQueueAlgorithm = algorithm == null ? new PRRNextQueueAlgorithm() : algorithm;
        this.nextQueueAlgorithm.init(queues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(E e) throws InterruptedException {
        Importance i = (Importance)e;
        InternalQueue<E> internalQueue = this.getQueueForPriority(i.getPriority());
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            try {
                while (internalQueue.remainingCapacity() == 0) {
                    internalQueue.getNotFullCond().await();
                }
            }
            catch (InterruptedException ie) {
                internalQueue.getNotFullCond().signal();
                throw ie;
            }
            internalQueue.offer(e);
            ++this.count;
            this.notEmpty.signal();
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e) {
        Importance i = (Importance)e;
        InternalQueue<E> internalQueue = this.getQueueForPriority(i.getPriority());
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            if (internalQueue.remainingCapacity() > 0) {
                internalQueue.offer(e);
                ++this.count;
                this.notEmpty.signal();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 7[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E take() throws InterruptedException {
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            InternalQueue<E> internalQueue = this.nextQueueAlgorithm.getNextQueue();
            try {
                while (internalQueue == null) {
                    this.notEmpty.await();
                    internalQueue = this.nextQueueAlgorithm.getNextQueue();
                }
            }
            catch (InterruptedException ie) {
                this.notEmpty.signal();
                throw ie;
            }
            Object e = internalQueue.poll();
            --this.count;
            internalQueue.getNotFullCond().signal();
            Object e2 = e;
            return e2;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 7[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> c) {
        int count = 0;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            for (InternalQueue<? super E> internalQueue : this.queues) {
                count += internalQueue.drainTo(c);
            }
            this.count -= count;
        }
        finally {
            lock.unlock();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        int elementsCopied = 0;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            for (InternalQueue<? super E> internalQueue : this.queues) {
                elementsCopied += internalQueue.drainTo(c, internalQueue.size() > maxElements - elementsCopied ? maxElements - elementsCopied : internalQueue.size());
            }
            this.count -= elementsCopied;
        }
        finally {
            lock.unlock();
        }
        return elementsCopied;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            InternalQueue<E> internalQueue = this.nextQueueAlgorithm.getNextQueue();
            if (internalQueue != null) {
                --this.count;
                Object e = internalQueue.poll();
                internalQueue.getNotFullCond().signal();
                Object e2 = e;
                return e2;
            }
            E e = null;
            return e;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public int remainingCapacity() {
        return this.capacity - this.count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E peek() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            InternalQueue<E> internalQueue = this.nextQueueAlgorithm.getNextQueue();
            if (internalQueue != null) {
                Object e = internalQueue.peek();
                return e;
            }
            E e = null;
            return e;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public Iterator<E> iterator() {
        return new QueueIterator(this.toArray());
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            for (InternalQueue<E> internalQueue : this.queues) {
                if (!internalQueue.remove(o)) continue;
                --this.count;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object o) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            for (InternalQueue<E> internalQueue : this.queues) {
                if (!internalQueue.contains(o)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            StringBuffer s = new StringBuffer();
            for (InternalQueue<E> internalQueue : this.queues) {
                s.append(internalQueue.toString());
            }
            String string = s.toString();
            return string;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            for (InternalQueue<E> intQueue : this.queues) {
                intQueue.clear();
            }
            this.count = 0;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] a) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            ArrayList<E> list = new ArrayList<E>();
            for (InternalQueue<E> internalQueue : this.queues) {
                list.addAll(internalQueue);
            }
            T[] TArray = list.toArray(a);
            return TArray;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            ArrayList<E> list = new ArrayList<E>();
            for (InternalQueue<E> internalQueue : this.queues) {
                list.addAll(internalQueue);
            }
            Object[] objectArray = list.toArray();
            return objectArray;
        }
        finally {
            lock.unlock();
        }
    }

    private InternalQueue<E> getQueueForPriority(int priority) {
        for (InternalQueue<E> q : this.queues) {
            if (q.getPriority() != priority) continue;
            return q;
        }
        throw new IllegalArgumentException();
    }

    public List<InternalQueue<E>> getQueues() {
        return this.queues;
    }

    public NextQueueAlgorithm<E> getNextQueueAlgorithm() {
        return this.nextQueueAlgorithm;
    }

    public boolean isFixedSizeQueues() {
        return this.isFixedSizeQueues;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QueueIterator
    implements Iterator<E> {
        final Object[] array;
        int cursor;
        int lastRet = -1;

        QueueIterator(Object[] array) {
            this.array = array;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.array.length;
        }

        @Override
        public E next() {
            if (this.cursor >= this.array.length) {
                throw new NoSuchElementException();
            }
            this.lastRet = this.cursor;
            return this.array[this.cursor++];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            Object x = this.array[this.lastRet];
            this.lastRet = -1;
            MultiPriorityBlockingQueue.this.lock.lock();
            try {
                for (InternalQueue internalQueue : MultiPriorityBlockingQueue.this.queues) {
                    Iterator it = internalQueue.iterator();
                    while (it.hasNext()) {
                        if (it.next() != x) continue;
                        it.remove();
                        return;
                    }
                }
            }
            finally {
                MultiPriorityBlockingQueue.this.lock.unlock();
            }
        }
    }
}

