/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.evaluators.config;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.evaluators.AndEvaluator;
import org.apache.synapse.commons.evaluators.Evaluator;
import org.apache.synapse.commons.evaluators.EvaluatorException;
import org.apache.synapse.commons.evaluators.config.EvaluatorFactory;
import org.apache.synapse.commons.evaluators.config.EvaluatorFactoryFinder;

public class AndFactory
implements EvaluatorFactory {
    private Log log = LogFactory.getLog(AndFactory.class);

    public Evaluator create(OMElement e) throws EvaluatorException {
        AndEvaluator o = new AndEvaluator();
        Iterator it = e.getChildElements();
        ArrayList<Evaluator> evaluators = new ArrayList<Evaluator>();
        while (it.hasNext()) {
            OMElement evaluatorElement = (OMElement)it.next();
            EvaluatorFactory ef = EvaluatorFactoryFinder.getInstance().findEvaluatorFactory(evaluatorElement.getLocalName());
            if (ef == null) {
                this.handleException("Invalid configuration element: " + evaluatorElement.getLocalName());
                return null;
            }
            Evaluator evaluator = ef.create(evaluatorElement);
            evaluators.add(evaluator);
        }
        if (evaluators.size() <= 1) {
            this.handleException("Two or more expressions should be provided under And");
            return null;
        }
        o.setEvaluators(evaluators.toArray(new Evaluator[evaluators.size()]));
        return o;
    }

    private void handleException(String message) throws EvaluatorException {
        this.log.error((Object)message);
        throw new EvaluatorException(message);
    }
}

