/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.evaluators;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.evaluators.Evaluator;
import org.apache.synapse.commons.evaluators.EvaluatorContext;
import org.apache.synapse.commons.evaluators.EvaluatorException;
import org.apache.synapse.commons.evaluators.source.SourceTextRetriever;

public class MatchEvaluator
implements Evaluator {
    private Log log = LogFactory.getLog(MatchEvaluator.class);
    private SourceTextRetriever textRetriever;
    private Pattern regex = null;

    public boolean evaluate(EvaluatorContext context) throws EvaluatorException {
        String sourceText = this.textRetriever.getSourceText(context);
        if (sourceText == null) {
            return false;
        }
        Matcher matcher = this.regex.matcher(sourceText);
        return matcher.matches();
    }

    public String getName() {
        return "match";
    }

    public Pattern getRegex() {
        return this.regex;
    }

    public void setRegex(Pattern regex) {
        this.regex = regex;
    }

    public SourceTextRetriever getTextRetriever() {
        return this.textRetriever;
    }

    public void setTextRetriever(SourceTextRetriever textRetriever) {
        this.textRetriever = textRetriever;
    }

    private void handleException(String message) throws EvaluatorException {
        this.log.error((Object)message);
        throw new EvaluatorException(message);
    }
}

