/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.tiles;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.ognl.OgnlUtil;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import ognl.OgnlException;
import org.apache.struts2.ServletActionContext;
import org.apache.tiles.context.TilesRequestContext;
import org.apache.tiles.evaluator.AbstractAttributeEvaluator;
import org.apache.tiles.evaluator.EvaluationException;
import org.apache.tiles.servlet.context.ServletUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StrutsAttributeEvaluator
extends AbstractAttributeEvaluator {
    private static final Logger LOG = LoggerFactory.getLogger(StrutsAttributeEvaluator.class);

    public Object evaluate(String expression, TilesRequestContext request) {
        try {
            HttpServletRequest httpRequest = ServletUtil.getServletRequest((TilesRequestContext)request).getRequest();
            ActionContext ctx = ServletActionContext.getActionContext((HttpServletRequest)httpRequest);
            if (ctx == null) {
                LOG.error("Cannot obtain HttpServletRequest from [{}]", new String[]{request.getClass().getName()});
                throw new ConfigurationException("There is no ActionContext for current request!");
            }
            OgnlUtil ognlUtil = (OgnlUtil)ctx.getContainer().getInstance(OgnlUtil.class);
            LOG.debug("Trying evaluate expression [{}] using OgnlUtil's getValue", new String[]{expression});
            Object result = ognlUtil.getValue(expression, ctx.getContextMap(), (Object)ctx.getValueStack().getRoot());
            LOG.debug("Final result of evaluating expression [{}] is: {}", new Object[]{expression, result});
            return result;
        }
        catch (OgnlException e) {
            throw new EvaluationException((Exception)((Object)e));
        }
    }

    public void init(Map<String, String> initParameters) {
    }
}

