/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.spring;

import com.opensymphony.xwork2.util.classloader.FileResourceStore;
import com.opensymphony.xwork2.util.classloader.JarResourceStore;
import com.opensymphony.xwork2.util.classloader.ReloadingClassLoader;
import com.opensymphony.xwork2.util.classloader.ResourceStore;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import org.apache.commons.jci.monitor.FilesystemAlterationListener;
import org.apache.commons.jci.monitor.FilesystemAlterationMonitor;
import org.apache.commons.jci.monitor.FilesystemAlterationObserver;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.dispatcher.Dispatcher;
import org.apache.struts2.spring.ClassReloadingBeanFactory;
import org.apache.struts2.spring.ClassReloadingInstantiationStrategy;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.InstantiationStrategy;
import org.springframework.web.context.support.XmlWebApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassReloadingXMLWebApplicationContext
extends XmlWebApplicationContext
implements FilesystemAlterationListener {
    private static final Logger LOG = LoggerFactory.getLogger(ClassReloadingXMLWebApplicationContext.class);
    protected ReloadingClassLoader classLoader;
    protected FilesystemAlterationMonitor fam;
    protected ClassReloadingBeanFactory beanFactory;
    private boolean reloadConfig;

    public void setupReloading(String[] watchList, String acceptClasses, ServletContext servletContext, boolean reloadConfig) {
        this.reloadConfig = reloadConfig;
        this.classLoader = new ReloadingClassLoader(ClassReloadingXMLWebApplicationContext.class.getClassLoader());
        if (StringUtils.isNotBlank((String)acceptClasses)) {
            String[] splitted = acceptClasses.split(",");
            HashSet<Pattern> patterns = new HashSet<Pattern>(splitted.length);
            for (String pattern : splitted) {
                patterns.add(Pattern.compile(pattern));
            }
            this.classLoader.setAccepClasses(patterns);
        }
        this.fam = new FilesystemAlterationMonitor();
        for (String watch : watchList) {
            File file = new File(watch);
            if (!file.isAbsolute()) {
                file = new File(servletContext.getRealPath(watch));
            }
            if (watch.endsWith(".jar")) {
                this.classLoader.addResourceStore((ResourceStore)new JarResourceStore(file));
                this.fam.addListener(file, (FilesystemAlterationListener)this);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Watching [#0] for changes", new String[]{file.getAbsolutePath()});
                continue;
            }
            ArrayList<File> dirs = new ArrayList<File>();
            this.getAllPaths(file, dirs);
            this.classLoader.addResourceStore((ResourceStore)new FileResourceStore(file));
            for (File dir : dirs) {
                this.fam.addListener(dir, (FilesystemAlterationListener)this);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Watching [#0] for changes", new String[]{dir.getAbsolutePath()});
            }
        }
        this.beanFactory = new ClassReloadingBeanFactory();
        this.beanFactory.setInstantiationStrategy((InstantiationStrategy)new ClassReloadingInstantiationStrategy());
        this.beanFactory.setBeanClassLoader((ClassLoader)this.classLoader);
        this.fam.start();
    }

    private void getAllPaths(File root, List<File> dirs) {
        File[] files;
        dirs.add(root);
        if (root.isDirectory() && (files = root.listFiles()) != null) {
            for (File file : files) {
                if (!file.isDirectory()) continue;
                this.getAllPaths(file, dirs);
            }
        }
    }

    public void close() {
        super.close();
        if (this.fam != null) {
            this.fam.removeListener((FilesystemAlterationListener)this);
            this.fam.stop();
        }
    }

    public void refresh() throws BeansException, IllegalStateException {
        if (this.classLoader != null) {
            this.classLoader.reload();
        }
        super.refresh();
    }

    protected DefaultListableBeanFactory createBeanFactory() {
        return this.beanFactory != null ? this.beanFactory : super.createBeanFactory();
    }

    protected void prepareBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        super.prepareBeanFactory(beanFactory);
        if (this.classLoader != null) {
            beanFactory.setBeanClassLoader((ClassLoader)this.classLoader);
        }
    }

    public void onDirectoryChange(File file) {
        this.reload(file);
    }

    public void onDirectoryCreate(File file) {
        this.reload(file);
    }

    public void onDirectoryDelete(File file) {
    }

    public void onFileChange(File file) {
        this.reload(file);
    }

    public void onFileCreate(File file) {
        this.reload(file);
    }

    private void reload(File file) {
        if (this.classLoader != null) {
            boolean debugEnabled = LOG.isDebugEnabled();
            if (debugEnabled) {
                LOG.debug("Change detected in file [#0], reloading class loader", new String[]{file.getAbsolutePath()});
            }
            this.classLoader.reload();
            if (this.reloadConfig && Dispatcher.getInstance() != null) {
                if (debugEnabled) {
                    LOG.debug("Change detected in file [#0], reloading configuration", new String[]{file.getAbsolutePath()});
                }
                Dispatcher.getInstance().getConfigurationManager().reload();
            }
        }
    }

    public void onFileDelete(File file) {
    }

    public void onStart(FilesystemAlterationObserver filesystemAlterationObserver) {
    }

    public void onStop(FilesystemAlterationObserver filesystemAlterationObserver) {
    }

    public ReloadingClassLoader getReloadingClassLoader() {
        return this.classLoader;
    }
}

