/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.portlet.servlet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.struts2.portlet.PortletConstants;
import org.apache.struts2.portlet.servlet.PortletHttpSession;
import org.apache.struts2.portlet.servlet.PortletServletInputStream;
import org.apache.struts2.portlet.servlet.PortletServletRequestDispatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletServletRequest
implements HttpServletRequest {
    private PortletRequest portletRequest;
    private PortletContext portletContext;
    private Map<String, String[]> extraParams;

    public PortletServletRequest(PortletRequest portletRequest, PortletContext portletContext) {
        this(portletRequest, portletContext, Collections.EMPTY_MAP);
    }

    public PortletServletRequest(PortletRequest portletRequest, PortletContext portletContext, Map<String, String[]> extraParams) {
        this.portletContext = portletContext;
        this.portletRequest = portletRequest;
        this.extraParams = extraParams;
    }

    public String getAuthType() {
        return this.portletRequest.getAuthType();
    }

    public String getContextPath() {
        return this.portletRequest.getContextPath();
    }

    public Cookie[] getCookies() {
        if (this.portletRequest instanceof HttpServletRequest) {
            return ((HttpServletRequest)this.portletRequest).getCookies();
        }
        throw new IllegalStateException("Not allowed in a portlet");
    }

    public long getDateHeader(String name) {
        throw new IllegalStateException("Not allowed in a portlet");
    }

    public String getHeader(String name) {
        return this.portletRequest.getProperty(name);
    }

    public Enumeration getHeaderNames() {
        return this.portletRequest.getPropertyNames();
    }

    public Enumeration getHeaders(String name) {
        return this.portletRequest.getProperties(name);
    }

    public int getIntHeader(String name) {
        throw new IllegalStateException("Not allowed in a portlet");
    }

    public String getMethod() {
        return null;
    }

    public String getPathInfo() {
        return null;
    }

    public String getPathTranslated() {
        return null;
    }

    public String getQueryString() {
        return null;
    }

    public String getRemoteUser() {
        return this.portletRequest.getRemoteUser();
    }

    public String getRequestURI() {
        throw new IllegalStateException("Not allowed in a portlet");
    }

    public StringBuffer getRequestURL() {
        throw new IllegalStateException("Not allowed in a portlet");
    }

    public String getRequestedSessionId() {
        return this.portletRequest.getRequestedSessionId();
    }

    public String getServletPath() {
        String actionPath = this.getParameter(PortletConstants.ACTION_PARAM);
        if (actionPath != null && !actionPath.endsWith(".action")) {
            actionPath = actionPath + ".action";
        }
        return actionPath;
    }

    public HttpSession getSession() {
        return new PortletHttpSession(this.portletRequest.getPortletSession());
    }

    public HttpSession getSession(boolean create) {
        return new PortletHttpSession(this.portletRequest.getPortletSession(create));
    }

    public Principal getUserPrincipal() {
        return this.portletRequest.getUserPrincipal();
    }

    public boolean isRequestedSessionIdFromCookie() {
        throw new IllegalStateException("Not allowed in a portlet");
    }

    public boolean isRequestedSessionIdFromURL() {
        throw new IllegalStateException("Not allowed in a portlet");
    }

    public boolean isRequestedSessionIdFromUrl() {
        throw new IllegalStateException("Not allowed in a portlet");
    }

    public boolean isRequestedSessionIdValid() {
        return this.portletRequest.isRequestedSessionIdValid();
    }

    public boolean isUserInRole(String role) {
        return this.portletRequest.isUserInRole(role);
    }

    public Object getAttribute(String name) {
        if ("javax.servlet.include.servlet_path".equals(name)) {
            return this.getServletPath();
        }
        return this.portletRequest.getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        return this.portletRequest.getAttributeNames();
    }

    public String getCharacterEncoding() {
        if (this.portletRequest instanceof ActionRequest) {
            return ((ActionRequest)this.portletRequest).getCharacterEncoding();
        }
        throw new IllegalStateException("Not allowed in render phase");
    }

    public int getContentLength() {
        if (this.portletRequest instanceof ActionRequest) {
            return ((ActionRequest)this.portletRequest).getContentLength();
        }
        throw new IllegalStateException("Not allowed in render phase");
    }

    public String getContentType() {
        if (this.portletRequest instanceof ActionRequest) {
            return ((ActionRequest)this.portletRequest).getContentType();
        }
        throw new IllegalStateException("Not allowed in render phase");
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.portletRequest instanceof ActionRequest) {
            return new PortletServletInputStream(((ActionRequest)this.portletRequest).getPortletInputStream());
        }
        throw new IllegalStateException("Not allowed in render phase");
    }

    public String getLocalAddr() {
        if (this.portletRequest instanceof HttpServletRequest) {
            return ((HttpServletRequest)this.portletRequest).getLocalAddr();
        }
        throw new IllegalStateException("Not allowed in a portlet");
    }

    public String getLocalName() {
        if (this.portletRequest instanceof HttpServletRequest) {
            return ((HttpServletRequest)this.portletRequest).getLocalName();
        }
        throw new IllegalStateException("Not allowed in a portlet");
    }

    public int getLocalPort() {
        if (this.portletRequest instanceof HttpServletRequest) {
            return ((HttpServletRequest)this.portletRequest).getLocalPort();
        }
        throw new IllegalStateException("Not allowed in a portlet");
    }

    public Locale getLocale() {
        return this.portletRequest.getLocale();
    }

    public Enumeration getLocales() {
        return this.portletRequest.getLocales();
    }

    public String getParameter(String name) {
        String[] values;
        if (this.extraParams.containsKey(name) && (values = this.extraParams.get(name)) != null && values.length > 0) {
            return values[0];
        }
        return this.portletRequest.getParameter(name);
    }

    public Map getParameterMap() {
        return this.portletRequest.getParameterMap();
    }

    public Enumeration getParameterNames() {
        return this.portletRequest.getParameterNames();
    }

    public String[] getParameterValues(String name) {
        return this.portletRequest.getParameterValues(name);
    }

    public String getProtocol() {
        if (this.portletRequest instanceof HttpServletRequest) {
            return ((HttpServletRequest)this.portletRequest).getProtocol();
        }
        throw new IllegalStateException("Not allowed in a portlet");
    }

    public BufferedReader getReader() throws IOException {
        if (this.portletRequest instanceof ActionRequest) {
            return ((ActionRequest)this.portletRequest).getReader();
        }
        throw new IllegalStateException("Not allowed in render phase");
    }

    public String getRealPath(String path) {
        return this.portletContext.getRealPath(path);
    }

    public String getRemoteAddr() {
        if (this.portletRequest instanceof HttpServletRequest) {
            return ((HttpServletRequest)this.portletRequest).getRemoteAddr();
        }
        throw new IllegalStateException("Not allowed in a portlet");
    }

    public String getRemoteHost() {
        if (this.portletRequest instanceof HttpServletRequest) {
            return ((HttpServletRequest)this.portletRequest).getRemoteHost();
        }
        throw new IllegalStateException("Not allowed in a portlet");
    }

    public int getRemotePort() {
        if (this.portletRequest instanceof HttpServletRequest) {
            return ((HttpServletRequest)this.portletRequest).getRemotePort();
        }
        throw new IllegalStateException("Not allowed in a portlet");
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return new PortletServletRequestDispatcher(this.portletContext.getRequestDispatcher(path));
    }

    public String getScheme() {
        return this.portletRequest.getScheme();
    }

    public String getServerName() {
        return this.portletRequest.getServerName();
    }

    public int getServerPort() {
        if (this.portletRequest instanceof HttpServletRequest) {
            return ((HttpServletRequest)this.portletRequest).getServerPort();
        }
        throw new IllegalStateException("Not allowed in a portlet");
    }

    public boolean isSecure() {
        return this.portletRequest.isSecure();
    }

    public void removeAttribute(String name) {
        this.portletRequest.removeAttribute(name);
    }

    public void setAttribute(String name, Object o) {
        this.portletRequest.setAttribute(name, o);
    }

    public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
        if (!(this.portletRequest instanceof ActionRequest)) {
            throw new IllegalStateException("Not allowed in render phase");
        }
        ((ActionRequest)this.portletRequest).setCharacterEncoding(env);
    }

    public PortletRequest getPortletRequest() {
        return this.portletRequest;
    }
}

