/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.components;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.inject.Inject;
import java.io.IOException;
import java.io.Writer;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.StrutsException;
import org.apache.struts2.components.Form;
import org.apache.struts2.components.ServletUrlRenderer;
import org.apache.struts2.components.UrlProvider;
import org.apache.struts2.components.UrlRenderer;
import org.apache.struts2.dispatcher.mapper.ActionMapper;
import org.apache.struts2.portlet.context.PortletActionContext;
import org.apache.struts2.portlet.util.PortletUrlHelper;

public class PortletUrlRenderer
implements UrlRenderer {
    private UrlRenderer servletRenderer = new ServletUrlRenderer();

    @Inject
    public void setActionMapper(ActionMapper actionMapper) {
        this.servletRenderer.setActionMapper(actionMapper);
    }

    public void renderUrl(Writer writer, UrlProvider urlComponent) {
        if (PortletActionContext.getPortletContext() == null || "none".equalsIgnoreCase(urlComponent.getPortletUrlType())) {
            this.servletRenderer.renderUrl(writer, urlComponent);
        } else {
            String var;
            String action = null;
            if (urlComponent.getAction() != null) {
                action = urlComponent.findString(urlComponent.getAction());
            }
            String scheme = urlComponent.getHttpServletRequest().getScheme();
            if (urlComponent.getScheme() != null) {
                scheme = urlComponent.getScheme();
            }
            urlComponent.setNamespace(urlComponent.determineNamespace(urlComponent.getNamespace(), urlComponent.getStack(), urlComponent.getHttpServletRequest()));
            String result = this.onlyActionSpecified(urlComponent) ? PortletUrlHelper.buildUrl(action, urlComponent.getNamespace(), urlComponent.getMethod(), urlComponent.getParameters(), urlComponent.getPortletUrlType(), urlComponent.getPortletMode(), urlComponent.getWindowState()) : (this.onlyValueSpecified(urlComponent) ? PortletUrlHelper.buildResourceUrl(urlComponent.getValue(), urlComponent.getParameters()) : this.createDefaultUrl(urlComponent));
            String anchor = urlComponent.getAnchor();
            if (StringUtils.isNotEmpty((String)anchor)) {
                result = result + '#' + urlComponent.findString(anchor);
            }
            if ((var = urlComponent.getVar()) != null) {
                urlComponent.putInContext(result);
                urlComponent.getHttpServletRequest().setAttribute(var, (Object)result);
            } else {
                try {
                    writer.write(result);
                }
                catch (IOException e) {
                    throw new StrutsException("IOError: " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private String createDefaultUrl(UrlProvider urlComponent) {
        ActionInvocation ai = (ActionInvocation)urlComponent.getStack().getContext().get("com.opensymphony.xwork2.ActionContext.actionInvocation");
        String action = ai.getProxy().getActionName();
        String result = PortletUrlHelper.buildUrl(action, urlComponent.getNamespace(), urlComponent.getMethod(), urlComponent.getParameters(), urlComponent.getPortletUrlType(), urlComponent.getPortletMode(), urlComponent.getWindowState());
        return result;
    }

    private boolean onlyValueSpecified(UrlProvider urlComponent) {
        return urlComponent.getValue() != null && urlComponent.getAction() == null;
    }

    private boolean onlyActionSpecified(UrlProvider urlComponent) {
        return urlComponent.getValue() == null && urlComponent.getAction() != null;
    }

    public void renderFormUrl(Form formComponent) {
        if (PortletActionContext.getPortletContext() == null) {
            this.servletRenderer.renderFormUrl(formComponent);
        } else {
            String namespace = formComponent.determineNamespace(formComponent.namespace, formComponent.getStack(), formComponent.request);
            String action = null;
            if (formComponent.action != null) {
                action = formComponent.findString(formComponent.action);
            } else {
                ActionInvocation ai = (ActionInvocation)formComponent.getStack().getContext().get("com.opensymphony.xwork2.ActionContext.actionInvocation");
                action = ai.getProxy().getActionName();
            }
            String type = "action";
            if (StringUtils.isNotEmpty((String)formComponent.method) && "GET".equalsIgnoreCase(formComponent.method.trim())) {
                type = "render";
            }
            if (action != null) {
                String result = PortletUrlHelper.buildUrl(action, namespace, null, formComponent.getParameters(), type, formComponent.portletMode, formComponent.windowState);
                formComponent.addParameter("action", (Object)result);
                String id = formComponent.getId();
                if (id == null) {
                    int slash = action.lastIndexOf(47);
                    int dot = action.indexOf(46, slash);
                    id = dot != -1 ? action.substring(slash + 1, dot) : action.substring(slash + 1);
                    formComponent.addParameter("id", (Object)formComponent.escape(id));
                }
            }
        }
    }

    public void beforeRenderUrl(UrlProvider urlComponent) {
        if (PortletActionContext.getPortletContext() == null) {
            this.servletRenderer.beforeRenderUrl(urlComponent);
        }
    }

    public void setServletRenderer(UrlRenderer nonPortletRenderer) {
        this.servletRenderer = nonPortletRenderer;
    }
}

