/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.json.smd;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts2.json.JSONUtil;
import org.apache.struts2.json.smd.SMD;
import org.apache.struts2.json.smd.SMDMethod;
import org.apache.struts2.json.smd.SMDMethodParameter;

public class SMDGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(SMDGenerator.class);
    private Object rootObject;
    private List<Pattern> excludeProperties;
    private boolean ignoreInterfaces;

    public SMDGenerator(Object root, List<Pattern> excludeProperties, boolean ignoreInterfaces) {
        this.rootObject = root;
        this.excludeProperties = excludeProperties;
        this.ignoreInterfaces = ignoreInterfaces;
    }

    public SMD generate(ActionInvocation actionInvocation) {
        Method[] methods;
        ActionContext actionContext = actionInvocation.getInvocationContext();
        HttpServletRequest request = (HttpServletRequest)actionContext.get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
        Class<?> clazz = this.rootObject.getClass();
        SMD smd = new SMD();
        smd.setServiceUrl(request.getRequestURI());
        org.apache.struts2.json.annotations.SMD smdAnnotation = clazz.getAnnotation(org.apache.struts2.json.annotations.SMD.class);
        if (smdAnnotation != null) {
            smd.setObjectName(smdAnnotation.objectName());
            smd.setServiceType(smdAnnotation.serviceType());
            smd.setVersion(smdAnnotation.version());
        }
        for (Method method : methods = JSONUtil.listSMDMethods(clazz, this.ignoreInterfaces)) {
            this.processAnnotatedMethod(smd, method);
        }
        return smd;
    }

    private void processAnnotatedMethod(SMD smd, Method method) {
        org.apache.struts2.json.annotations.SMDMethod smdMethodAnnotation = method.getAnnotation(org.apache.struts2.json.annotations.SMDMethod.class);
        if (this.shouldProcessMethod(method, smdMethodAnnotation)) {
            String methodName = this.readMethodName(method, smdMethodAnnotation);
            SMDMethod smdMethod = new SMDMethod(methodName);
            smd.addSMDMethod(smdMethod);
            this.processMethodsParameters(method, smdMethod);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Ignoring property " + method.getName(), new String[0]);
        }
    }

    private void processMethodsParameters(Method method, SMDMethod smdMethod) {
        int parametersCount = method.getParameterTypes().length;
        if (parametersCount > 0) {
            Annotation[][] parameterAnnotations = method.getParameterAnnotations();
            for (int i = 0; i < parametersCount; ++i) {
                this.processParameter(smdMethod, parameterAnnotations[i], i);
            }
        }
    }

    private void processParameter(SMDMethod smdMethod, Annotation[] parameterAnnotation, int i) {
        org.apache.struts2.json.annotations.SMDMethodParameter smdMethodParameterAnnotation = this.getSMDMethodParameterAnnotation(parameterAnnotation);
        String paramName = this.buildParamName(i, smdMethodParameterAnnotation);
        smdMethod.addSMDMethodParameter(new SMDMethodParameter(paramName));
    }

    private String buildParamName(int i, org.apache.struts2.json.annotations.SMDMethodParameter smdMethodParameterAnnotation) {
        return smdMethodParameterAnnotation != null ? smdMethodParameterAnnotation.name() : "p" + i;
    }

    private String readMethodName(Method method, org.apache.struts2.json.annotations.SMDMethod smdMethodAnnotation) {
        return smdMethodAnnotation.name().length() == 0 ? method.getName() : smdMethodAnnotation.name();
    }

    private boolean shouldProcessMethod(Method method, org.apache.struts2.json.annotations.SMDMethod smdMethodAnnotation) {
        return smdMethodAnnotation != null && !this.shouldExcludeProperty(method.getName());
    }

    private boolean shouldExcludeProperty(String expr) {
        if (this.excludeProperties != null) {
            for (Pattern pattern : this.excludeProperties) {
                if (!pattern.matcher(expr).matches()) continue;
                return true;
            }
        }
        return false;
    }

    private org.apache.struts2.json.annotations.SMDMethodParameter getSMDMethodParameterAnnotation(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof org.apache.struts2.json.annotations.SMDMethodParameter)) continue;
            return (org.apache.struts2.json.annotations.SMDMethodParameter)annotation;
        }
        return null;
    }
}

