/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.async;

import com.opensymphony.xwork2.AsyncManager;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.async.AsyncAction;

public class DefaultAsyncManager
implements AsyncManager,
AsyncListener {
    private static final Logger LOG = LogManager.getLogger(DefaultAsyncManager.class);
    private static final AtomicInteger threadCount = new AtomicInteger(0);
    private AsyncContext asyncContext;
    private boolean asyncActionStarted;
    private Boolean asyncCompleted;
    private Object asyncActionResult;

    public void invokeAsyncAction(final Callable asyncAction) {
        if (this.asyncActionStarted) {
            return;
        }
        Long timeout = null;
        Executor executor = null;
        if (asyncAction instanceof AsyncAction) {
            AsyncAction customAsyncAction = (AsyncAction)asyncAction;
            timeout = customAsyncAction.getTimeout();
            executor = customAsyncAction.getExecutor();
        }
        HttpServletRequest req = ServletActionContext.getRequest();
        this.asyncActionResult = null;
        this.asyncCompleted = false;
        if (this.asyncContext == null || !req.isAsyncStarted()) {
            this.asyncContext = req.startAsync((ServletRequest)req, (ServletResponse)ServletActionContext.getResponse());
            this.asyncContext.addListener((AsyncListener)this);
            if (timeout != null) {
                this.asyncContext.setTimeout(timeout.longValue());
            }
        }
        this.asyncActionStarted = true;
        LOG.debug("Async processing started for " + this.asyncContext);
        final Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    DefaultAsyncManager.this.setAsyncActionResultAndDispatch(asyncAction.call());
                }
                catch (Throwable e) {
                    DefaultAsyncManager.this.setAsyncActionResultAndDispatch(e);
                }
            }
        };
        if (executor != null) {
            executor.execute(task);
        } else {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        task.run();
                    }
                    finally {
                        threadCount.decrementAndGet();
                    }
                }
            }, this.getClass().getSimpleName() + "-" + threadCount.incrementAndGet());
            thread.start();
        }
    }

    private void setAsyncActionResultAndDispatch(Object asyncActionResult) {
        this.asyncActionResult = asyncActionResult;
        String log = "Async result [" + asyncActionResult + "] of " + this.asyncContext;
        if (this.asyncCompleted.booleanValue()) {
            LOG.debug(log + " - could not complete result executing due to timeout or network error");
        } else {
            LOG.debug(log + " - dispatching request to execute result in container");
            this.asyncContext.dispatch();
        }
    }

    public boolean hasAsyncActionResult() {
        return this.asyncActionResult != null;
    }

    public Object getAsyncActionResult() {
        return this.asyncActionResult;
    }

    public void onComplete(AsyncEvent asyncEvent) throws IOException {
        this.asyncContext = null;
        this.asyncCompleted = true;
    }

    public void onTimeout(AsyncEvent asyncEvent) throws IOException {
        LOG.debug("Processing timeout for " + asyncEvent.getAsyncContext());
        this.setAsyncActionResultAndDispatch("timeout");
    }

    public void onError(AsyncEvent asyncEvent) throws IOException {
        Throwable e = asyncEvent.getThrowable();
        LOG.error("Processing error for " + asyncEvent.getAsyncContext(), e);
        this.setAsyncActionResultAndDispatch(e);
    }

    public void onStartAsync(AsyncEvent asyncEvent) throws IOException {
    }
}

