/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.receiver.tenant;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.broker.publish.EventPublisher;
import org.apache.stratos.messaging.broker.publish.EventPublisherPool;
import org.apache.stratos.messaging.broker.subscribe.EventSubscriber;
import org.apache.stratos.messaging.event.initializer.CompleteTenantRequestEvent;
import org.apache.stratos.messaging.listener.EventListener;
import org.apache.stratos.messaging.message.receiver.StratosEventReceiver;
import org.apache.stratos.messaging.message.receiver.tenant.TenantEventMessageDelegator;
import org.apache.stratos.messaging.message.receiver.tenant.TenantEventMessageListener;
import org.apache.stratos.messaging.message.receiver.tenant.TenantEventMessageQueue;
import org.apache.stratos.messaging.util.MessagingUtil;

public class TenantEventReceiver
extends StratosEventReceiver {
    private static final Log log = LogFactory.getLog(TenantEventReceiver.class);
    private TenantEventMessageDelegator messageDelegator;
    private TenantEventMessageListener messageListener;
    private EventSubscriber eventSubscriber;
    private static volatile TenantEventReceiver instance;

    private TenantEventReceiver() {
        TenantEventMessageQueue messageQueue = new TenantEventMessageQueue();
        this.messageDelegator = new TenantEventMessageDelegator(messageQueue);
        this.messageListener = new TenantEventMessageListener(messageQueue);
        this.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TenantEventReceiver getInstance() {
        if (instance != null) return instance;
        Class<TenantEventReceiver> clazz = TenantEventReceiver.class;
        synchronized (TenantEventReceiver.class) {
            if (instance != null) return instance;
            instance = new TenantEventReceiver();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public void addEventListener(EventListener eventListener) {
        this.messageDelegator.addEventListener(eventListener);
    }

    @Override
    public void removeEventListener(EventListener eventListener) {
        this.messageDelegator.removeEventListener(eventListener);
    }

    private void execute() {
        block4: {
            try {
                this.eventSubscriber = new EventSubscriber(MessagingUtil.Topics.TENANT_TOPIC.getTopicName(), this.messageListener);
                this.executor.execute(this.eventSubscriber);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Tenant event message receiver thread started");
                }
                this.executor.execute(this.messageDelegator);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Tenant event message delegator thread started");
                }
                this.initializeCompleteTenant();
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)"Tenant receiver failed", (Throwable)e);
            }
        }
    }

    public void initializeCompleteTenant() {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                while (!TenantEventReceiver.this.eventSubscriber.isSubscribed()) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                CompleteTenantRequestEvent completeTenantRequestEvent = new CompleteTenantRequestEvent();
                String topic = MessagingUtil.getMessageTopicName(completeTenantRequestEvent);
                EventPublisher eventPublisher = EventPublisherPool.getPublisher(topic);
                eventPublisher.publish(completeTenantRequestEvent);
            }
        });
    }

    @Override
    public void terminate() {
        this.eventSubscriber.terminate();
        this.messageDelegator.terminate();
    }
}

