/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.receiver.instance.status;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.domain.Message;
import org.apache.stratos.messaging.listener.EventListener;
import org.apache.stratos.messaging.message.processor.MessageProcessorChain;
import org.apache.stratos.messaging.message.processor.instance.status.InstanceStatusMessageProcessorChain;
import org.apache.stratos.messaging.message.receiver.instance.status.InstanceStatusEventMessageQueue;

class InstanceStatusEventMessageDelegator
implements Runnable {
    private static final Log log = LogFactory.getLog(InstanceStatusEventMessageDelegator.class);
    private InstanceStatusEventMessageQueue messageQueue;
    private MessageProcessorChain processorChain;
    private boolean terminated;

    public InstanceStatusEventMessageDelegator(InstanceStatusEventMessageQueue messageQueue) {
        this.messageQueue = messageQueue;
        this.processorChain = new InstanceStatusMessageProcessorChain();
    }

    public void addEventListener(EventListener eventListener) {
        this.processorChain.addEventListener(eventListener);
    }

    public void removeEventListener(EventListener eventListener) {
        this.processorChain.removeEventListener(eventListener);
    }

    @Override
    public void run() {
        block9: {
            try {
                if (log.isInfoEnabled()) {
                    log.info((Object)"Instance notifier event message delegator started");
                }
                while (!this.terminated) {
                    try {
                        Message message = (Message)this.messageQueue.take();
                        String type = message.getEventClassName();
                        String json = message.getText();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("Instance notifier event message received from queue: %s", type));
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("Delegating instance notifier event message: %s", type));
                        }
                        this.processorChain.process(type, json, null);
                    }
                    catch (InterruptedException ignore) {
                        log.info((Object)"Shutting down instance status event message delegator...");
                        this.terminate();
                    }
                    catch (Exception e) {
                        log.error((Object)"Failed to retrieve instance notifier event message", (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block9;
                log.error((Object)"Instance notifier event message delegator failed", (Throwable)e);
            }
        }
    }

    public void terminate() {
        this.terminated = true;
    }
}

