/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.receiver.initializer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.broker.subscribe.EventSubscriber;
import org.apache.stratos.messaging.listener.EventListener;
import org.apache.stratos.messaging.message.receiver.StratosEventReceiver;
import org.apache.stratos.messaging.message.receiver.initializer.InitializerEventMessageDelegator;
import org.apache.stratos.messaging.message.receiver.initializer.InitializerEventMessageListener;
import org.apache.stratos.messaging.message.receiver.initializer.InitializerEventMessageQueue;
import org.apache.stratos.messaging.util.MessagingUtil;

public class InitializerEventReceiver
extends StratosEventReceiver {
    private static final Log log = LogFactory.getLog(InitializerEventReceiver.class);
    private InitializerEventMessageDelegator messageDelegator;
    private InitializerEventMessageListener messageListener;
    private EventSubscriber eventSubscriber;
    private static volatile InitializerEventReceiver instance;

    private InitializerEventReceiver() {
        InitializerEventMessageQueue initializerEventMessageQueue = new InitializerEventMessageQueue();
        this.messageDelegator = new InitializerEventMessageDelegator(initializerEventMessageQueue);
        this.messageListener = new InitializerEventMessageListener(initializerEventMessageQueue);
        this.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static InitializerEventReceiver getInstance() {
        if (instance != null) return instance;
        Class<InitializerEventReceiver> clazz = InitializerEventReceiver.class;
        synchronized (InitializerEventReceiver.class) {
            if (instance != null) return instance;
            instance = new InitializerEventReceiver();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public void addEventListener(EventListener eventListener) {
        this.messageDelegator.addEventListener(eventListener);
    }

    @Override
    public void removeEventListener(EventListener eventListener) {
        this.messageDelegator.removeEventListener(eventListener);
    }

    private void execute() {
        block3: {
            try {
                this.eventSubscriber = new EventSubscriber(MessagingUtil.Topics.INITIALIZER_TOPIC.getTopicName(), this.messageListener);
                this.executor.execute(this.eventSubscriber);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Initializer event message delegator thread started");
                }
                this.executor.execute(this.messageDelegator);
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)"Initializer receiver failed", (Throwable)e);
            }
        }
    }

    @Override
    public void terminate() {
        this.eventSubscriber.terminate();
        this.messageDelegator.terminate();
    }
}

