/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.receiver.health.stat;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.broker.subscribe.EventSubscriber;
import org.apache.stratos.messaging.listener.EventListener;
import org.apache.stratos.messaging.message.receiver.StratosEventReceiver;
import org.apache.stratos.messaging.message.receiver.health.stat.HealthStatEventMessageDelegator;
import org.apache.stratos.messaging.message.receiver.health.stat.HealthStatEventMessageListener;
import org.apache.stratos.messaging.message.receiver.health.stat.HealthStatEventMessageQueue;
import org.apache.stratos.messaging.util.MessagingUtil;

public class HealthStatEventReceiver
extends StratosEventReceiver {
    private static final Log log = LogFactory.getLog(HealthStatEventReceiver.class);
    private final HealthStatEventMessageDelegator messageDelegator;
    private final HealthStatEventMessageListener messageListener;
    private EventSubscriber eventSubscriber;
    private static volatile HealthStatEventReceiver instance;

    private HealthStatEventReceiver() {
        HealthStatEventMessageQueue messageQueue = new HealthStatEventMessageQueue();
        this.messageDelegator = new HealthStatEventMessageDelegator(messageQueue);
        this.messageListener = new HealthStatEventMessageListener(messageQueue);
        this.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HealthStatEventReceiver getInstance() {
        if (instance != null) return instance;
        Class<HealthStatEventReceiver> clazz = HealthStatEventReceiver.class;
        synchronized (HealthStatEventReceiver.class) {
            if (instance != null) return instance;
            instance = new HealthStatEventReceiver();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public void addEventListener(EventListener eventListener) {
        this.messageDelegator.addEventListener(eventListener);
    }

    @Override
    public void removeEventListener(EventListener eventListener) {
        this.messageDelegator.removeEventListener(eventListener);
    }

    private void execute() {
        block3: {
            try {
                this.eventSubscriber = new EventSubscriber(MessagingUtil.Topics.HEALTH_STAT_TOPIC.getTopicName(), this.messageListener);
                this.executor.execute(this.eventSubscriber);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Health stats event message delegator thread started");
                }
                this.executor.execute(this.messageDelegator);
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)"Health stats receiver failed", (Throwable)e);
            }
        }
    }

    @Override
    public void terminate() {
        this.eventSubscriber.terminate();
        this.messageDelegator.terminate();
    }
}

