/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.receiver.cluster.status;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.broker.subscribe.EventSubscriber;
import org.apache.stratos.messaging.listener.EventListener;
import org.apache.stratos.messaging.message.receiver.StratosEventReceiver;
import org.apache.stratos.messaging.message.receiver.cluster.status.ClusterStatusEventMessageDelegator;
import org.apache.stratos.messaging.message.receiver.cluster.status.ClusterStatusEventMessageListener;
import org.apache.stratos.messaging.message.receiver.cluster.status.ClusterStatusEventMessageQueue;
import org.apache.stratos.messaging.util.MessagingUtil;

public class ClusterStatusEventReceiver
extends StratosEventReceiver {
    private static final Log log = LogFactory.getLog(ClusterStatusEventReceiver.class);
    private final ClusterStatusEventMessageDelegator messageDelegator;
    private final ClusterStatusEventMessageListener messageListener;
    private EventSubscriber eventSubscriber;
    private static volatile ClusterStatusEventReceiver instance;

    private ClusterStatusEventReceiver() {
        ClusterStatusEventMessageQueue messageQueue = new ClusterStatusEventMessageQueue();
        this.messageDelegator = new ClusterStatusEventMessageDelegator(messageQueue);
        this.messageListener = new ClusterStatusEventMessageListener(messageQueue);
        this.execute();
    }

    @Override
    public void addEventListener(EventListener eventListener) {
        this.messageDelegator.addEventListener(eventListener);
    }

    @Override
    public void removeEventListener(EventListener eventListener) {
        this.messageDelegator.removeEventListener(eventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ClusterStatusEventReceiver getInstance() {
        if (instance != null) return instance;
        Class<ClusterStatusEventReceiver> clazz = ClusterStatusEventReceiver.class;
        synchronized (ClusterStatusEventReceiver.class) {
            if (instance != null) return instance;
            instance = new ClusterStatusEventReceiver();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private void execute() {
        block4: {
            try {
                this.eventSubscriber = new EventSubscriber(MessagingUtil.Topics.CLUSTER_STATUS_TOPIC.getTopicName(), this.messageListener);
                this.executor.execute(this.eventSubscriber);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"InstanceNotifier event message receiver thread started");
                }
                this.executor.execute(this.messageDelegator);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"InstanceNotifier event message delegator thread started");
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)"InstanceNotifier receiver failed", (Throwable)e);
            }
        }
    }

    @Override
    public void terminate() {
        this.eventSubscriber.terminate();
        this.messageDelegator.terminate();
    }

    public boolean isSubscribed() {
        return this.eventSubscriber != null && this.eventSubscriber.isSubscribed();
    }
}

