/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.receiver.application.signup;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.broker.publish.EventPublisher;
import org.apache.stratos.messaging.broker.publish.EventPublisherPool;
import org.apache.stratos.messaging.broker.subscribe.EventSubscriber;
import org.apache.stratos.messaging.event.initializer.CompleteApplicationSignUpsRequestEvent;
import org.apache.stratos.messaging.listener.EventListener;
import org.apache.stratos.messaging.message.receiver.StratosEventReceiver;
import org.apache.stratos.messaging.message.receiver.application.signup.ApplicationSignUpEventMessageDelegator;
import org.apache.stratos.messaging.message.receiver.application.signup.ApplicationSignUpEventMessageListener;
import org.apache.stratos.messaging.message.receiver.application.signup.ApplicationSignUpEventMessageQueue;
import org.apache.stratos.messaging.util.MessagingUtil;

public class ApplicationSignUpEventReceiver
extends StratosEventReceiver {
    private static final Log log = LogFactory.getLog(ApplicationSignUpEventReceiver.class);
    private ApplicationSignUpEventMessageDelegator messageDelegator;
    private ApplicationSignUpEventMessageListener messageListener;
    private EventSubscriber eventSubscriber;
    private static volatile ApplicationSignUpEventReceiver instance;

    private ApplicationSignUpEventReceiver() {
        ApplicationSignUpEventMessageQueue messageQueue = new ApplicationSignUpEventMessageQueue();
        this.messageDelegator = new ApplicationSignUpEventMessageDelegator(messageQueue);
        this.messageListener = new ApplicationSignUpEventMessageListener(messageQueue);
        this.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ApplicationSignUpEventReceiver getInstance() {
        if (instance != null) return instance;
        Class<ApplicationSignUpEventReceiver> clazz = ApplicationSignUpEventReceiver.class;
        synchronized (ApplicationSignUpEventReceiver.class) {
            if (instance != null) return instance;
            instance = new ApplicationSignUpEventReceiver();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public void addEventListener(EventListener eventListener) {
        this.messageDelegator.addEventListener(eventListener);
    }

    @Override
    public void removeEventListener(EventListener eventListener) {
        this.messageDelegator.removeEventListener(eventListener);
    }

    private void execute() {
        block4: {
            try {
                this.eventSubscriber = new EventSubscriber(MessagingUtil.Topics.APPLICATION_SIGNUP_TOPIC.getTopicName(), this.messageListener);
                this.executor.execute(this.eventSubscriber);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Application signup event message receiver thread started");
                }
                this.executor.execute(this.messageDelegator);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Application signup event message delegator thread started");
                }
                this.initializeCompleteApplicationSignUps();
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)"Application signup receiver failed", (Throwable)e);
            }
        }
    }

    public void initializeCompleteApplicationSignUps() {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                while (!ApplicationSignUpEventReceiver.this.eventSubscriber.isSubscribed()) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                CompleteApplicationSignUpsRequestEvent completeApplicationSignUpsRequestEvent = new CompleteApplicationSignUpsRequestEvent();
                String topic = MessagingUtil.getMessageTopicName(completeApplicationSignUpsRequestEvent);
                EventPublisher eventPublisher = EventPublisherPool.getPublisher(topic);
                eventPublisher.publish(completeApplicationSignUpsRequestEvent);
            }
        });
    }

    @Override
    public void terminate() {
        this.eventSubscriber.terminate();
        this.messageDelegator.terminate();
    }
}

