/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.receiver.application;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.broker.publish.EventPublisher;
import org.apache.stratos.messaging.broker.publish.EventPublisherPool;
import org.apache.stratos.messaging.broker.subscribe.EventSubscriber;
import org.apache.stratos.messaging.event.initializer.CompleteApplicationsRequestEvent;
import org.apache.stratos.messaging.listener.EventListener;
import org.apache.stratos.messaging.message.receiver.StratosEventReceiver;
import org.apache.stratos.messaging.message.receiver.application.ApplicationsEventMessageDelegator;
import org.apache.stratos.messaging.message.receiver.application.ApplicationsEventMessageListener;
import org.apache.stratos.messaging.message.receiver.application.ApplicationsEventMessageQueue;
import org.apache.stratos.messaging.util.MessagingUtil;

public class ApplicationsEventReceiver
extends StratosEventReceiver {
    private static final Log log = LogFactory.getLog(ApplicationsEventReceiver.class);
    private ApplicationsEventMessageDelegator messageDelegator;
    private ApplicationsEventMessageListener messageListener;
    private EventSubscriber eventSubscriber;
    private static volatile ApplicationsEventReceiver instance;

    private ApplicationsEventReceiver() {
        ApplicationsEventMessageQueue messageQueue = new ApplicationsEventMessageQueue();
        this.messageDelegator = new ApplicationsEventMessageDelegator(messageQueue);
        this.messageListener = new ApplicationsEventMessageListener(messageQueue);
        this.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ApplicationsEventReceiver getInstance() {
        if (instance != null) return instance;
        Class<ApplicationsEventReceiver> clazz = ApplicationsEventReceiver.class;
        synchronized (ApplicationsEventReceiver.class) {
            if (instance != null) return instance;
            instance = new ApplicationsEventReceiver();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public void addEventListener(EventListener eventListener) {
        this.messageDelegator.addEventListener(eventListener);
    }

    @Override
    public void removeEventListener(EventListener eventListener) {
        this.messageDelegator.removeEventListener(eventListener);
    }

    private void execute() {
        block4: {
            try {
                this.eventSubscriber = new EventSubscriber(MessagingUtil.Topics.APPLICATION_TOPIC.getTopicName(), this.messageListener);
                this.executor.execute(this.eventSubscriber);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Application status event message receiver thread started");
                }
                this.executor.execute(this.messageDelegator);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Application status event message delegator thread started");
                }
                this.initializeCompleteApplicationsModel();
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)"Application status failed", (Throwable)e);
            }
        }
    }

    @Override
    public void terminate() {
        this.eventSubscriber.terminate();
        this.messageDelegator.terminate();
    }

    public void initializeCompleteApplicationsModel() {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                while (!ApplicationsEventReceiver.this.eventSubscriber.isSubscribed()) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                CompleteApplicationsRequestEvent completeApplicationsRequestEvent = new CompleteApplicationsRequestEvent();
                String topic = MessagingUtil.getMessageTopicName(completeApplicationsRequestEvent);
                EventPublisher eventPublisher = EventPublisherPool.getPublisher(topic);
                eventPublisher.publish(completeApplicationsRequestEvent);
            }
        });
    }
}

