/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.processor.application;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.domain.application.ApplicationStatus;
import org.apache.stratos.messaging.domain.application.Applications;
import org.apache.stratos.messaging.domain.instance.ApplicationInstance;
import org.apache.stratos.messaging.event.application.ApplicationInstanceTerminatedEvent;
import org.apache.stratos.messaging.message.processor.MessageProcessor;
import org.apache.stratos.messaging.message.processor.application.updater.ApplicationsUpdater;
import org.apache.stratos.messaging.util.MessagingUtil;

public class ApplicationInstanceTerminatedMessageProcessor
extends MessageProcessor {
    private static final Log log = LogFactory.getLog(ApplicationInstanceTerminatedMessageProcessor.class);
    private MessageProcessor nextProcessor;

    @Override
    public void setNext(MessageProcessor nextProcessor) {
        this.nextProcessor = nextProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(String type, String message, Object object) {
        Applications applications = (Applications)object;
        if (ApplicationInstanceTerminatedEvent.class.getName().equals(type)) {
            if (!applications.isInitialized()) {
                return false;
            }
            ApplicationInstanceTerminatedEvent event = (ApplicationInstanceTerminatedEvent)MessagingUtil.jsonToObject(message, ApplicationInstanceTerminatedEvent.class);
            ApplicationsUpdater.acquireWriteLockForApplications();
            try {
                boolean bl = this.doProcess(event, applications);
                return bl;
            }
            finally {
                ApplicationsUpdater.releaseWriteLockForApplications();
            }
        }
        if (this.nextProcessor != null) {
            return this.nextProcessor.process(type, message, applications);
        }
        throw new RuntimeException(String.format("Failed to process message using available message processors: [type] %s [body] %s", type, message));
    }

    private boolean doProcess(ApplicationInstanceTerminatedEvent event, Applications applications) {
        if (event.getAppId() == null) {
            String errorMsg = "Application Id of application to be removed event is null. Failed to process ApplicationInstanceTerminatedEvent";
            log.error((Object)errorMsg);
            throw new RuntimeException(errorMsg);
        }
        String appId = event.getAppId();
        String instanceId = event.getInstanceId();
        if (applications.applicationExists(appId)) {
            log.warn((Object)String.format("Application [application-id] %s still exists. Removing application instance [instance-id] %s", appId, instanceId));
            ApplicationInstance instance = (ApplicationInstance)applications.getApplication(appId).getInstanceContexts(instanceId);
            if (instance == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Application instance [instance-id] %s has already been removed", instanceId));
                }
            } else {
                instance.setStatus(ApplicationStatus.Terminated);
                applications.getApplication(appId).removeInstance(instanceId);
            }
        }
        this.notifyEventListeners(event);
        return true;
    }
}

