/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.common.threading.StratosThreadPool;
import org.apache.stratos.messaging.message.receiver.StratosEventReceiver;
import org.apache.stratos.messaging.message.receiver.application.ApplicationsEventReceiver;
import org.apache.stratos.messaging.message.receiver.application.signup.ApplicationSignUpEventReceiver;
import org.apache.stratos.messaging.message.receiver.cluster.status.ClusterStatusEventReceiver;
import org.apache.stratos.messaging.message.receiver.domain.mapping.DomainMappingEventReceiver;
import org.apache.stratos.messaging.message.receiver.health.stat.HealthStatEventReceiver;
import org.apache.stratos.messaging.message.receiver.initializer.InitializerEventReceiver;
import org.apache.stratos.messaging.message.receiver.tenant.TenantEventReceiver;
import org.apache.stratos.messaging.message.receiver.topology.TopologyEventReceiver;
import org.osgi.service.component.ComponentContext;

public class MessagingServiceComponent {
    private static final Log log = LogFactory.getLog(MessagingServiceComponent.class);

    protected void activate(ComponentContext context) {
        try {
            ApplicationSignUpEventReceiver.getInstance();
            ApplicationsEventReceiver.getInstance();
            ClusterStatusEventReceiver.getInstance();
            DomainMappingEventReceiver.getInstance();
            HealthStatEventReceiver.getInstance();
            InitializerEventReceiver.getInstance();
            TenantEventReceiver.getInstance();
            TopologyEventReceiver.getInstance();
            if (log.isDebugEnabled()) {
                log.debug((Object)"Messaging Service bundle activated");
            }
        }
        catch (Exception e) {
            log.error((Object)"Could not activate Messaging Service component", (Throwable)e);
        }
    }

    protected void deactivate(ComponentContext context) {
        try {
            ApplicationSignUpEventReceiver.getInstance().terminate();
            ApplicationsEventReceiver.getInstance().terminate();
            ClusterStatusEventReceiver.getInstance().terminate();
            DomainMappingEventReceiver.getInstance().terminate();
            HealthStatEventReceiver.getInstance().terminate();
            InitializerEventReceiver.getInstance().terminate();
            TenantEventReceiver.getInstance().terminate();
            TopologyEventReceiver.getInstance().terminate();
            StratosThreadPool.shutDownThreadPoolGracefully((String)StratosEventReceiver.STRATOS_EVENT_RECEIEVER_THREAD_POOL_ID);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Messaging Service component is deactivated");
            }
        }
        catch (Exception e) {
            log.error((Object)"Could not de-activate Messaging Service component", (Throwable)e);
        }
    }
}

