/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.broker.publish;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.broker.publish.EventPublisher;

public class EventPublisherPool {
    private static final Log log = LogFactory.getLog(EventPublisherPool.class);
    private static Map<String, EventPublisher> topicNameEventPublisherMap = new HashMap<String, EventPublisher>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EventPublisher getPublisher(String topicName) {
        Class<EventPublisherPool> clazz = EventPublisherPool.class;
        synchronized (EventPublisherPool.class) {
            if (topicNameEventPublisherMap.containsKey(topicName)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Event publisher fetched from pool: [topic] %s", topicName));
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return topicNameEventPublisherMap.get(topicName);
            }
            EventPublisher eventPublisher = new EventPublisher(topicName);
            topicNameEventPublisherMap.put(topicName, eventPublisher);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Event publisher instance created: [topic] %s", topicName));
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return eventPublisher;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close(String topicName) {
        Class<EventPublisherPool> clazz = EventPublisherPool.class;
        synchronized (EventPublisherPool.class) {
            if (topicNameEventPublisherMap.containsKey(topicName)) {
                topicNameEventPublisherMap.remove(topicName);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Event publisher closed and removed from pool: [topic] %s", topicName));
                }
            } else if (log.isWarnEnabled()) {
                log.warn((Object)String.format("Event publisher instance not found in pool: [topic] %s", topicName));
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

