/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.common.threading;

import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.common.threading.GracefulThreadPoolTerminator;
import org.apache.stratos.common.threading.StratosThreadFactory;

public class StratosThreadPool {
    private static final Log log = LogFactory.getLog(StratosThreadPool.class);
    private static volatile Map<String, ThreadPoolExecutor> executorMap = new ConcurrentHashMap<String, ThreadPoolExecutor>();
    private static volatile Map<String, ScheduledThreadPoolExecutor> scheduledExecutorMap = new ConcurrentHashMap<String, ScheduledThreadPoolExecutor>();
    private static final Object executorServiceMapLock = new Object();
    private static final Object scheduledServiceMapLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ThreadPoolExecutor getExecutorService(String identifier, int initialSize, int maxSize) {
        ThreadPoolExecutor executor = executorMap.get(identifier);
        if (executor == null) {
            Object object = executorServiceMapLock;
            synchronized (object) {
                if (executor == null) {
                    int taskQueueSize = initialSize > 4 ? (int)Math.ceil(initialSize / 4) : 1;
                    executor = new ThreadPoolExecutor(initialSize, maxSize, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(taskQueueSize), new StratosThreadFactory(identifier));
                    executorMap.put(identifier, executor);
                    log.info((Object)String.format("Thread pool created: [type] Executor [id] %s [initial size] %d [max size] %d [queue length] %d", identifier, initialSize, maxSize, taskQueueSize));
                }
            }
        }
        return executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ScheduledThreadPoolExecutor getScheduledExecutorService(String identifier, int threadPoolSize) {
        ScheduledThreadPoolExecutor scheduledExecutor = scheduledExecutorMap.get(identifier);
        if (scheduledExecutor == null) {
            Object object = scheduledServiceMapLock;
            synchronized (object) {
                if (scheduledExecutor == null) {
                    scheduledExecutor = new ScheduledThreadPoolExecutor(threadPoolSize, new StratosThreadFactory(identifier));
                    scheduledExecutorMap.put(identifier, scheduledExecutor);
                    log.info((Object)String.format("Thread pool created: [type] Scheduled Executor [id] %s [size] %d", identifier, threadPoolSize));
                }
            }
        }
        return scheduledExecutor;
    }

    public static void shutDownThreadPoolGracefully(String threadPoolId) {
        ThreadPoolExecutor executor = executorMap.get(threadPoolId);
        if (executor == null) {
            log.warn((Object)("No thread pool found for id " + threadPoolId + ", unable to shut down"));
            return;
        }
        new GracefulThreadPoolTerminator(threadPoolId, executor).call();
        StratosThreadPool.removeThreadPoolFromCache(threadPoolId);
    }

    public static void shutDownScheduledThreadPoolGracefully(String threadPoolId) {
        ScheduledThreadPoolExecutor scheduledExecutor = scheduledExecutorMap.get(threadPoolId);
        if (scheduledExecutor == null) {
            log.warn((Object)("No scheduled thread pool found for id " + threadPoolId + ", unable to shut down"));
            return;
        }
        new GracefulThreadPoolTerminator(threadPoolId, scheduledExecutor).call();
        StratosThreadPool.removeScheduledThreadPoolFromCache(threadPoolId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutDownAllThreadPoolsGracefully() {
        int threadPoolCount = executorMap.size();
        if (threadPoolCount == 0) {
            log.info((Object)"No thread pools found to shut down");
            return;
        }
        HashSet<Future<String>> threadPoolTerminatorFutures = new HashSet<Future<String>>();
        ExecutorService threadPoolTerminator = null;
        try {
            threadPoolTerminator = Executors.newFixedThreadPool(threadPoolCount);
            for (Map.Entry<String, ThreadPoolExecutor> entry : executorMap.entrySet()) {
                threadPoolTerminatorFutures.add(threadPoolTerminator.submit(new GracefulThreadPoolTerminator(entry.getKey(), entry.getValue())));
            }
            for (Future future : threadPoolTerminatorFutures) {
                StratosThreadPool.removeThreadPoolFromCache((String)future.get());
            }
        }
        catch (InterruptedException e) {
            log.error((Object)"Error in shutting down thread pools", (Throwable)e);
        }
        catch (ExecutionException e) {
            log.error((Object)"Error in shutting down thread pools", (Throwable)e);
        }
        finally {
            if (!executorMap.isEmpty()) {
                for (Map.Entry<String, ThreadPoolExecutor> entry : executorMap.entrySet()) {
                    entry.getValue().shutdownNow();
                    StratosThreadPool.removeThreadPoolFromCache(entry.getKey());
                }
            }
            threadPoolTerminator.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutDownAllScheduledExecutorsGracefully() {
        int threadPoolCount = scheduledExecutorMap.size();
        if (threadPoolCount == 0) {
            log.info((Object)"No thread pools found to shut down");
            return;
        }
        HashSet<Future<String>> threadPoolTerminatorFutures = new HashSet<Future<String>>();
        ExecutorService threadPoolTerminator = null;
        try {
            threadPoolTerminator = Executors.newFixedThreadPool(threadPoolCount);
            for (Map.Entry<String, ScheduledThreadPoolExecutor> entry : scheduledExecutorMap.entrySet()) {
                threadPoolTerminatorFutures.add(threadPoolTerminator.submit(new GracefulThreadPoolTerminator(entry.getKey(), entry.getValue())));
            }
            for (Future future : threadPoolTerminatorFutures) {
                StratosThreadPool.removeScheduledThreadPoolFromCache((String)future.get());
            }
        }
        catch (InterruptedException e) {
            log.error((Object)"Error in shutting down thread pools", (Throwable)e);
        }
        catch (ExecutionException e) {
            log.error((Object)"Error in shutting down thread pools", (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)"Error in shutting down thread pools", (Throwable)e);
        }
        finally {
            if (!scheduledExecutorMap.isEmpty()) {
                for (Map.Entry<String, ScheduledThreadPoolExecutor> entry : scheduledExecutorMap.entrySet()) {
                    entry.getValue().shutdownNow();
                    StratosThreadPool.removeScheduledThreadPoolFromCache(entry.getKey());
                }
            }
            threadPoolTerminator.shutdownNow();
        }
    }

    private static void removeThreadPoolFromCache(String terminatedPoolId) {
        if (executorMap.remove(terminatedPoolId) != null) {
            log.info((Object)("Thread pool [id] " + terminatedPoolId + " is successfully shut down" + " and removed from the cache"));
        }
    }

    private static void removeScheduledThreadPoolFromCache(String terminatedPoolId) {
        if (scheduledExecutorMap.remove(terminatedPoolId) != null) {
            log.info((Object)("Scheduled Thread pool [id] " + terminatedPoolId + " is successfully shut down" + " and removed from the cache"));
        }
    }
}

