/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.common.threading;

import java.util.concurrent.Callable;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GracefulThreadPoolTerminator
implements Callable<String> {
    private static final Log log = LogFactory.getLog(GracefulThreadPoolTerminator.class);
    private String threadPoolId;
    private ThreadPoolExecutor executor;

    public GracefulThreadPoolTerminator(String threadPoolId, ThreadPoolExecutor executor) {
        this.threadPoolId = threadPoolId;
        this.executor = executor;
    }

    @Override
    public String call() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Attempting to gracefully shut down thread pool " + this.threadPoolId));
        }
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Thread Pool [id] " + this.threadPoolId + " did not finish all tasks before " + "timeout, forcefully shutting down"));
                }
                this.executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.executor.shutdownNow();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Successfully shut down thread pool " + this.threadPoolId));
        }
        return this.threadPoolId;
    }
}

