/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.processor.application;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.domain.application.Application;
import org.apache.stratos.messaging.domain.application.ApplicationStatus;
import org.apache.stratos.messaging.domain.application.Applications;
import org.apache.stratos.messaging.domain.instance.ApplicationInstance;
import org.apache.stratos.messaging.event.application.ApplicationInstanceTerminatingEvent;
import org.apache.stratos.messaging.message.processor.MessageProcessor;
import org.apache.stratos.messaging.message.processor.application.updater.ApplicationsUpdater;
import org.apache.stratos.messaging.util.MessagingUtil;

public class ApplicationInstanceTerminatingMessageProcessor
extends MessageProcessor {
    private static final Log log = LogFactory.getLog(ApplicationInstanceTerminatingMessageProcessor.class);
    private MessageProcessor nextProcessor;

    @Override
    public void setNext(MessageProcessor nextProcessor) {
        this.nextProcessor = nextProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(String type, String message, Object object) {
        Applications applications = (Applications)object;
        if (ApplicationInstanceTerminatingEvent.class.getName().equals(type)) {
            if (!applications.isInitialized()) {
                return false;
            }
            ApplicationInstanceTerminatingEvent event = (ApplicationInstanceTerminatingEvent)MessagingUtil.jsonToObject(message, ApplicationInstanceTerminatingEvent.class);
            ApplicationsUpdater.acquireWriteLockForApplication(event.getAppId());
            try {
                boolean bl = this.doProcess(event, applications);
                return bl;
            }
            finally {
                ApplicationsUpdater.releaseWriteLockForApplication(event.getAppId());
            }
        }
        if (this.nextProcessor != null) {
            return this.nextProcessor.process(type, message, applications);
        }
        throw new RuntimeException(String.format("Failed to process message using available message processors: [type] %s [body] %s", type, message));
    }

    private boolean doProcess(ApplicationInstanceTerminatingEvent event, Applications applications) {
        Application application = applications.getApplication(event.getAppId());
        if (application == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)String.format("Application does not exist: [application-id] %s", event.getAppId()));
            }
            return false;
        }
        ApplicationInstance applicationInstance = (ApplicationInstance)application.getInstanceContexts(event.getInstanceId());
        if (applicationInstance == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)String.format("Application instance does not exist in group: [application-id] %s, [instance-id] %s", event.getAppId(), event.getInstanceId()));
            }
            return false;
        }
        ApplicationStatus currentStatus = applicationInstance.getStatus();
        if (!applicationInstance.isStateTransitionValid(ApplicationStatus.Terminating)) {
            log.error((Object)String.format("Invalid application state transfer [from] %s [to] %s", currentStatus, ApplicationStatus.Terminating));
            return false;
        }
        applicationInstance.setStatus(ApplicationStatus.Terminating);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Application instance status updated [from] %s [to] %s for [instance-id] %s", currentStatus, ApplicationStatus.Terminating, applicationInstance.getInstanceId()));
        }
        this.notifyEventListeners(event);
        return true;
    }
}

