/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.domain.topology;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.stratos.messaging.domain.topology.Cluster;
import org.apache.stratos.messaging.domain.topology.Port;
import org.apache.stratos.messaging.domain.topology.ServiceType;
import org.apache.stratos.messaging.domain.topology.locking.TopologyLockHierarchy;

public class Service
implements Serializable {
    private static final long serialVersionUID = -8835648141999889756L;
    private final String serviceName;
    private final ServiceType serviceType;
    private Map<String, Cluster> clusterIdClusterMap;
    private Map<Integer, Port> portMap;
    private Properties properties;

    public Service(String serviceName, ServiceType serviceType) {
        this.serviceName = serviceName;
        this.serviceType = serviceType;
        this.clusterIdClusterMap = new HashMap<String, Cluster>();
        this.portMap = new HashMap<Integer, Port>();
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public ServiceType getServiceType() {
        return this.serviceType;
    }

    public Collection<Cluster> getClusters() {
        return this.clusterIdClusterMap.values();
    }

    public void addCluster(Cluster cluster) {
        this.clusterIdClusterMap.put(cluster.getClusterId(), cluster);
    }

    public void removeCluster(Cluster cluster) {
        this.clusterIdClusterMap.remove(cluster.getClusterId());
        TopologyLockHierarchy.getInstance().removeTopologyLockForCluster(cluster.getClusterId());
    }

    public Cluster removeCluster(String clusterId) {
        Cluster removedCluster = this.clusterIdClusterMap.remove(clusterId);
        TopologyLockHierarchy.getInstance().removeTopologyLockForCluster(clusterId);
        return removedCluster;
    }

    public boolean clusterExists(String clusterId) {
        return this.clusterIdClusterMap.containsKey(clusterId);
    }

    public Cluster getCluster(String clusterId) {
        return this.clusterIdClusterMap.get(clusterId);
    }

    public Collection<Port> getPorts() {
        return Collections.unmodifiableCollection(this.portMap.values());
    }

    public Port getPort(int proxy) {
        if (this.portMap.containsKey(proxy)) {
            return this.portMap.get(proxy);
        }
        return null;
    }

    public void addPort(Port port) {
        this.portMap.put(port.getProxy(), port);
    }

    public void addPorts(Collection<Port> ports) {
        for (Port port : ports) {
            this.addPort(port);
        }
    }

    public void removePort(Port port) {
        this.portMap.remove(port.getProxy());
    }

    public boolean portExists(Port port) {
        return this.portMap.containsKey(port.getProxy());
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public String toString() {
        return "Service [serviceName=" + this.serviceName + ", serviceType=" + (Object)((Object)this.serviceType) + ", clusterIdClusterMap=" + this.clusterIdClusterMap + ", portMap=" + this.portMap + ", properties=" + this.properties + "]";
    }
}

