/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.lock.proxy;

import com.hazelcast.concurrent.lock.InternalLockNamespace;
import com.hazelcast.concurrent.lock.LockServiceImpl;
import com.hazelcast.concurrent.lock.proxy.ConditionImpl;
import com.hazelcast.concurrent.lock.proxy.LockProxySupport;
import com.hazelcast.core.ICondition;
import com.hazelcast.core.ILock;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.AbstractDistributedObject;
import com.hazelcast.spi.NodeEngine;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;

public class LockProxy
extends AbstractDistributedObject<LockServiceImpl>
implements ILock {
    final Data key;
    final InternalLockNamespace namespace = new InternalLockNamespace();
    private final LockProxySupport lockSupport;

    public LockProxy(NodeEngine nodeEngine, LockServiceImpl lockService, Data key) {
        super(nodeEngine, lockService);
        this.key = key;
        this.lockSupport = new LockProxySupport(this.namespace);
    }

    @Override
    public boolean isLocked() {
        return this.lockSupport.isLocked(this.getNodeEngine(), this.key);
    }

    @Override
    public boolean isLockedByCurrentThread() {
        return this.lockSupport.isLockedByCurrentThread(this.getNodeEngine(), this.key);
    }

    @Override
    public int getLockCount() {
        return this.lockSupport.getLockCount(this.getNodeEngine(), this.key);
    }

    @Override
    public long getRemainingLeaseTime() {
        return this.lockSupport.getRemainingLeaseTime(this.getNodeEngine(), this.key);
    }

    @Override
    public void lock() {
        this.lockSupport.lock(this.getNodeEngine(), this.key);
    }

    @Override
    public void lock(long ttl, TimeUnit timeUnit) {
        this.lockSupport.lock(this.getNodeEngine(), this.key, timeUnit.toMillis(ttl));
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        this.lock();
    }

    @Override
    public boolean tryLock() {
        return this.lockSupport.tryLock(this.getNodeEngine(), this.key);
    }

    @Override
    public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
        return this.lockSupport.tryLock(this.getNodeEngine(), this.key, time, unit);
    }

    @Override
    public void unlock() {
        this.lockSupport.unlock(this.getNodeEngine(), this.key);
    }

    @Override
    public void forceUnlock() {
        this.lockSupport.forceUnlock(this.getNodeEngine(), this.key);
    }

    @Override
    public Condition newCondition() {
        throw new UnsupportedOperationException("Use ICondition.newCondition(String name) instead!");
    }

    @Override
    public ICondition newCondition(String name) {
        return new ConditionImpl(this, name);
    }

    @Override
    public Object getId() {
        return this.key;
    }

    @Override
    public String getName() {
        return String.valueOf(this.getKey());
    }

    @Override
    public String getServiceName() {
        return "hz:impl:lockService";
    }

    @Override
    public Object getKey() {
        return this.getNodeEngine().toObject(this.key);
    }
}

