/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http;

import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class TransportHeaders
implements Map<String, String> {
    HttpServletRequest request;
    Map<String, String> localHeaderMap = new HashMap<String, String>();
    private boolean localDataPopulated;

    public TransportHeaders(HttpServletRequest request) {
        this.request = request;
    }

    private void populateLocalData() {
        Enumeration headers = this.getRequest().getHeaderNames();
        if (headers != null) {
            this.localHeaderMap = new HashMap<String, String>();
            while (headers.hasMoreElements()) {
                String name = (String)headers.nextElement();
                this.localHeaderMap.put(name.toLowerCase(), this.getRequest().getHeader(name));
            }
        } else {
            throw new RuntimeException("The HTTP request header names cannot be enumerated");
        }
        this.localDataPopulated = true;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public boolean isLocalDataPopulated() {
        return this.localDataPopulated;
    }

    public Map<String, String> getLocalData() {
        return this.localHeaderMap;
    }

    public void checkAndPopulatedLocalData() {
        if (!this.isLocalDataPopulated()) {
            this.populateLocalData();
        }
    }

    @Override
    public int size() {
        this.checkAndPopulatedLocalData();
        return this.getLocalData().size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        this.checkAndPopulatedLocalData();
        return this.getLocalData().containsKey(key.toString().toLowerCase());
    }

    @Override
    public boolean containsValue(Object value) {
        this.checkAndPopulatedLocalData();
        return this.getLocalData().containsValue(value);
    }

    @Override
    public String get(Object key) {
        if (this.isLocalDataPopulated()) {
            return this.getLocalData().get(key.toString().toLowerCase());
        }
        return this.getRequest().getHeader(key.toString());
    }

    @Override
    public String put(String key, String value) {
        this.checkAndPopulatedLocalData();
        return this.getLocalData().put(key.toLowerCase(), value);
    }

    @Override
    public String remove(Object key) {
        this.checkAndPopulatedLocalData();
        return this.getLocalData().remove(key.toString().toLowerCase());
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> map) {
        this.checkAndPopulatedLocalData();
        for (Map.Entry<? extends String, ? extends String> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.checkAndPopulatedLocalData();
        this.getLocalData().clear();
    }

    @Override
    public Set<String> keySet() {
        this.checkAndPopulatedLocalData();
        return this.getLocalData().keySet();
    }

    @Override
    public Collection<String> values() {
        this.checkAndPopulatedLocalData();
        return this.getLocalData().values();
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        this.checkAndPopulatedLocalData();
        return this.getLocalData().entrySet();
    }
}

