/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.utility;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.ws.WebServiceException;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.i18n.Messages;

public class SAAJFactory {
    private static final String SOAP11_ENV_NS = "http://schemas.xmlsoap.org/soap/envelope/";
    private static final String SOAP12_ENV_NS = "http://www.w3.org/2003/05/soap-envelope";
    public static final String SOAP_1_1_PROTOCOL = "SOAP 1.1 Protocol";
    public static final String SOAP_1_2_PROTOCOL = "SOAP 1.2 Protocol";
    public static final String DYNAMIC_PROTOCOL = "Dynamic Protocol";
    private static Map<String, MessageFactory> _mmap = new ConcurrentHashMap<String, MessageFactory>();
    private static Map<String, SOAPFactory> _smap = new ConcurrentHashMap<String, SOAPFactory>();
    private static Method messageFactoryNewInstanceProtocolMethod = null;
    private static Method soapFactoryNewInstanceProtocolMethod = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SOAPFactory createSOAPFactory(String namespace) throws WebServiceException, SOAPException {
        SOAPFactory sf = null;
        sf = _smap.get(namespace);
        if (sf != null) {
            return sf;
        }
        Method m = SAAJFactory.getSOAPFactoryNewInstanceProtocolMethod();
        if (m == null) {
            if (!namespace.equals(SOAP11_ENV_NS)) throw ExceptionFactory.makeWebServiceException(Messages.getMessage("SOAP12WithSAAJ12Err"));
            sf = SOAPFactory.newInstance();
        } else {
            String protocol = DYNAMIC_PROTOCOL;
            if (namespace.equals(SOAP11_ENV_NS)) {
                protocol = SOAP_1_1_PROTOCOL;
            } else if (namespace.equals(SOAP12_ENV_NS)) {
                protocol = SOAP_1_2_PROTOCOL;
            }
            try {
                sf = (SOAPFactory)m.invoke(null, protocol);
            }
            catch (Exception e) {
                throw ExceptionFactory.makeWebServiceException(e);
            }
        }
        if (sf == null) return sf;
        _smap.put(namespace, sf);
        return sf;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MessageFactory createMessageFactory(String namespace) throws WebServiceException, SOAPException {
        MessageFactory mf = null;
        mf = _mmap.get(namespace);
        if (mf != null) {
            return mf;
        }
        Method m = SAAJFactory.getMessageFactoryNewInstanceProtocolMethod();
        if (m == null) {
            if (!namespace.equals(SOAP11_ENV_NS)) throw ExceptionFactory.makeWebServiceException(Messages.getMessage("SOAP12WithSAAJ12Err"));
            mf = MessageFactory.newInstance();
        } else {
            String protocol = DYNAMIC_PROTOCOL;
            if (namespace.equals(SOAP11_ENV_NS)) {
                protocol = SOAP_1_1_PROTOCOL;
            } else if (namespace.equals(SOAP12_ENV_NS)) {
                protocol = SOAP_1_2_PROTOCOL;
            }
            try {
                mf = (MessageFactory)m.invoke(null, protocol);
            }
            catch (Exception e) {
                throw ExceptionFactory.makeWebServiceException(e);
            }
        }
        if (mf == null) return mf;
        _mmap.put(namespace, mf);
        return mf;
    }

    private static Method getMessageFactoryNewInstanceProtocolMethod() {
        if (messageFactoryNewInstanceProtocolMethod == null) {
            try {
                messageFactoryNewInstanceProtocolMethod = MessageFactory.class.getMethod("newInstance", String.class);
            }
            catch (Exception e) {
                messageFactoryNewInstanceProtocolMethod = null;
            }
        }
        return messageFactoryNewInstanceProtocolMethod;
    }

    private static Method getSOAPFactoryNewInstanceProtocolMethod() {
        if (soapFactoryNewInstanceProtocolMethod == null) {
            try {
                soapFactoryNewInstanceProtocolMethod = SOAPFactory.class.getMethod("newInstance", String.class);
            }
            catch (Exception e) {
                soapFactoryNewInstanceProtocolMethod = null;
            }
        }
        return soapFactoryNewInstanceProtocolMethod;
    }
}

