/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.transport.network;

import java.nio.ByteBuffer;
import org.wso2.andes.transport.Binding;
import org.wso2.andes.transport.Connection;
import org.wso2.andes.transport.ConnectionDelegate;
import org.wso2.andes.transport.Receiver;
import org.wso2.andes.transport.Sender;
import org.wso2.andes.transport.network.Assembler;
import org.wso2.andes.transport.network.Disassembler;
import org.wso2.andes.transport.network.InputHandler;
import org.wso2.andes.transport.network.security.sasl.SASLReceiver;
import org.wso2.andes.transport.network.security.sasl.SASLSender;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConnectionBinding
implements Binding<Connection, ByteBuffer> {
    public static final int MAX_FRAME_SIZE = 65535;

    public static Binding<Connection, ByteBuffer> get(final Connection connection) {
        return new ConnectionBinding(){

            public Connection connection() {
                return connection;
            }
        };
    }

    public static Binding<Connection, ByteBuffer> get(final ConnectionDelegate delegate) {
        return new ConnectionBinding(){

            public Connection connection() {
                Connection conn = new Connection();
                conn.setConnectionDelegate(delegate);
                return conn;
            }
        };
    }

    public abstract Connection connection();

    @Override
    public Connection endpoint(Sender<ByteBuffer> sender) {
        Connection conn = this.connection();
        if (conn.getConnectionSettings() != null && conn.getConnectionSettings().isUseSASLEncryption()) {
            sender = new SASLSender(sender);
            conn.addConnectionListener(sender);
        }
        Disassembler dis = new Disassembler(sender, 65535);
        conn.setSender(dis);
        return conn;
    }

    @Override
    public Receiver<ByteBuffer> receiver(Connection conn) {
        if (conn.getConnectionSettings() != null && conn.getConnectionSettings().isUseSASLEncryption()) {
            SASLReceiver receiver = new SASLReceiver(new InputHandler(new Assembler(conn)));
            conn.addConnectionListener(receiver);
            return receiver;
        }
        return new InputHandler(new Assembler(conn));
    }
}

