/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.utils;

import java.util.ArrayList;
import java.util.List;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.utils.Pageable;

public final class DataPaginator {
    private static final int DEFAULT_NO_OF_ITEMS_PER_PAGE = 10;

    private DataPaginator() {
    }

    public static <C> List<C> doPaging(int pageNumber, List<C> sourceList, Pageable pageable) {
        int numberOfPages;
        if (sourceList.size() == 0) {
            return sourceList;
        }
        int pageToReturn = pageNumber < 0 || pageNumber == Integer.MAX_VALUE ? 0 : pageNumber;
        String itemsPerPage = ServerConfiguration.getInstance().getFirstProperty("ItemsPerPage");
        int itemsPerPageInt = 10;
        if (itemsPerPage != null) {
            itemsPerPageInt = Integer.parseInt(itemsPerPage);
        }
        if (pageToReturn > (numberOfPages = (int)Math.ceil((double)sourceList.size() / (double)itemsPerPageInt)) - 1) {
            pageToReturn = numberOfPages - 1;
        }
        int startIndex = pageToReturn * itemsPerPageInt;
        int endIndex = (pageToReturn + 1) * itemsPerPageInt;
        ArrayList<C> returnList = new ArrayList<C>();
        for (int i = startIndex; i < endIndex && i < sourceList.size(); ++i) {
            returnList.add(sourceList.get(i));
        }
        pageable.setNumberOfPages(numberOfPages);
        pageable.set(returnList);
        return returnList;
    }
}

