/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.common.client;

import java.rmi.RemoteException;
import org.apache.axis2.AxisFault;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.cloud.controller.stub.CloudControllerServiceCartridgeAlreadyExistsExceptionException;
import org.apache.stratos.cloud.controller.stub.CloudControllerServiceCartridgeDefinitionNotExistsExceptionException;
import org.apache.stratos.cloud.controller.stub.CloudControllerServiceCartridgeNotFoundExceptionException;
import org.apache.stratos.cloud.controller.stub.CloudControllerServiceClusterInstanceCreationExceptionException;
import org.apache.stratos.cloud.controller.stub.CloudControllerServiceInvalidCartridgeDefinitionExceptionException;
import org.apache.stratos.cloud.controller.stub.CloudControllerServiceInvalidCartridgeTypeExceptionException;
import org.apache.stratos.cloud.controller.stub.CloudControllerServiceInvalidIaasProviderExceptionException;
import org.apache.stratos.cloud.controller.stub.CloudControllerServiceInvalidKubernetesClusterExceptionException;
import org.apache.stratos.cloud.controller.stub.CloudControllerServiceInvalidKubernetesHostExceptionException;
import org.apache.stratos.cloud.controller.stub.CloudControllerServiceInvalidKubernetesMasterExceptionException;
import org.apache.stratos.cloud.controller.stub.CloudControllerServiceInvalidNetworkPartitionExceptionException;
import org.apache.stratos.cloud.controller.stub.CloudControllerServiceInvalidPartitionExceptionException;
import org.apache.stratos.cloud.controller.stub.CloudControllerServiceInvalidServiceGroupExceptionException;
import org.apache.stratos.cloud.controller.stub.CloudControllerServiceKubernetesClusterAlreadyExistsExceptionException;
import org.apache.stratos.cloud.controller.stub.CloudControllerServiceKubernetesClusterAlreadyUsedExceptionException;
import org.apache.stratos.cloud.controller.stub.CloudControllerServiceNetworkPartitionAlreadyExistsExceptionException;
import org.apache.stratos.cloud.controller.stub.CloudControllerServiceNetworkPartitionNotExistsExceptionException;
import org.apache.stratos.cloud.controller.stub.CloudControllerServiceNonExistingKubernetesClusterExceptionException;
import org.apache.stratos.cloud.controller.stub.CloudControllerServiceNonExistingKubernetesHostExceptionException;
import org.apache.stratos.cloud.controller.stub.CloudControllerServiceNonExistingKubernetesMasterExceptionException;
import org.apache.stratos.cloud.controller.stub.CloudControllerServiceStub;
import org.apache.stratos.cloud.controller.stub.domain.Cartridge;
import org.apache.stratos.cloud.controller.stub.domain.ClusterContext;
import org.apache.stratos.cloud.controller.stub.domain.Dependencies;
import org.apache.stratos.cloud.controller.stub.domain.NetworkPartition;
import org.apache.stratos.cloud.controller.stub.domain.ServiceGroup;
import org.apache.stratos.cloud.controller.stub.domain.kubernetes.KubernetesCluster;
import org.apache.stratos.cloud.controller.stub.domain.kubernetes.KubernetesHost;
import org.apache.stratos.cloud.controller.stub.domain.kubernetes.KubernetesMaster;

public class CloudControllerServiceClient {
    private CloudControllerServiceStub stub;
    private static final Log log = LogFactory.getLog(CloudControllerServiceClient.class);
    private static volatile CloudControllerServiceClient instance;

    private CloudControllerServiceClient(String epr) throws AxisFault {
        String ccSocketTimeout = System.getProperty("cc.socket.timeout") == null ? "300000" : System.getProperty("cc.socket.timeout");
        String ccConnectionTimeout = System.getProperty("cc.connection.timeout") == null ? "300000" : System.getProperty("cc.connection.timeout");
        try {
            this.stub = new CloudControllerServiceStub(epr);
            this.stub._getServiceClient().getOptions().setProperty("SO_TIMEOUT", (Object)Integer.valueOf(ccSocketTimeout));
            this.stub._getServiceClient().getOptions().setProperty("CONNECTION_TIMEOUT", (Object)new Integer(ccConnectionTimeout));
        }
        catch (AxisFault axisFault) {
            String msg = "Could not initialize cloud controller service client";
            log.error((Object)msg, (Throwable)axisFault);
            throw new AxisFault(msg, (Throwable)axisFault);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CloudControllerServiceClient getInstance() throws AxisFault {
        if (instance != null) return instance;
        Class<CloudControllerServiceClient> clazz = CloudControllerServiceClient.class;
        synchronized (CloudControllerServiceClient.class) {
            if (instance != null) return instance;
            String cloudControllerServiceUrl = System.getProperty("cloud.controller.service.url");
            if (StringUtils.isBlank((String)cloudControllerServiceUrl)) {
                throw new RuntimeException(String.format("System property not found: %s", "cloud.controller.service.url"));
            }
            instance = new CloudControllerServiceClient(cloudControllerServiceUrl);
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void addCartridge(Cartridge cartridgeConfig) throws RemoteException, CloudControllerServiceCartridgeAlreadyExistsExceptionException, CloudControllerServiceInvalidCartridgeDefinitionExceptionException, CloudControllerServiceInvalidIaasProviderExceptionException {
        this.stub.addCartridge(cartridgeConfig);
    }

    public void updateCartridge(Cartridge cartridgeConfig) throws RemoteException, CloudControllerServiceInvalidCartridgeDefinitionExceptionException, CloudControllerServiceInvalidIaasProviderExceptionException, CloudControllerServiceCartridgeDefinitionNotExistsExceptionException {
        this.stub.updateCartridge(cartridgeConfig);
    }

    public void removeCartridge(String cartridgeType) throws RemoteException, CloudControllerServiceInvalidCartridgeTypeExceptionException {
        this.stub.removeCartridge(cartridgeType);
    }

    public String[] getServiceGroupSubGroups(String name) throws RemoteException, CloudControllerServiceInvalidServiceGroupExceptionException {
        return this.stub.getServiceGroupSubGroups(name);
    }

    public String[] getServiceGroupCartridges(String name) throws RemoteException, CloudControllerServiceInvalidServiceGroupExceptionException {
        return this.stub.getServiceGroupCartridges(name);
    }

    public Dependencies getServiceGroupDependencies(String name) throws RemoteException, CloudControllerServiceInvalidServiceGroupExceptionException {
        return this.stub.getServiceGroupDependencies(name);
    }

    public ServiceGroup getServiceGroup(String name) throws RemoteException, CloudControllerServiceInvalidServiceGroupExceptionException {
        return this.stub.getServiceGroup(name);
    }

    public String[] getRegisteredCartridges() throws RemoteException {
        return this.stub.getCartridges();
    }

    public Cartridge getCartridge(String cartridgeType) throws RemoteException, CloudControllerServiceCartridgeNotFoundExceptionException {
        return this.stub.getCartridge(cartridgeType);
    }

    public ClusterContext getClusterContext(String clusterId) throws RemoteException {
        return this.stub.getClusterContext(clusterId);
    }

    public boolean updateKubernetesCluster(KubernetesCluster kubernetesCluster) throws RemoteException, CloudControllerServiceInvalidKubernetesClusterExceptionException {
        return this.stub.updateKubernetesCluster(kubernetesCluster);
    }

    public boolean deployKubernetesCluster(KubernetesCluster kubernetesCluster) throws RemoteException, CloudControllerServiceInvalidKubernetesClusterExceptionException, CloudControllerServiceKubernetesClusterAlreadyExistsExceptionException {
        return this.stub.addKubernetesCluster(kubernetesCluster);
    }

    public boolean addKubernetesHost(String kubernetesClusterId, KubernetesHost kubernetesHost) throws RemoteException, CloudControllerServiceInvalidKubernetesHostExceptionException, CloudControllerServiceNonExistingKubernetesClusterExceptionException {
        return this.stub.addKubernetesHost(kubernetesClusterId, kubernetesHost);
    }

    public boolean updateKubernetesMaster(KubernetesMaster kubernetesMaster) throws RemoteException, CloudControllerServiceInvalidKubernetesMasterExceptionException, CloudControllerServiceNonExistingKubernetesMasterExceptionException {
        return this.stub.updateKubernetesMaster(kubernetesMaster);
    }

    public KubernetesCluster[] getAvailableKubernetesClusters() throws RemoteException {
        return this.stub.getKubernetesClusters();
    }

    public KubernetesCluster getKubernetesCluster(String kubernetesClusterId) throws RemoteException, CloudControllerServiceNonExistingKubernetesClusterExceptionException {
        return this.stub.getKubernetesCluster(kubernetesClusterId);
    }

    public void undeployKubernetesCluster(String kubernetesClusterId) throws RemoteException, CloudControllerServiceNonExistingKubernetesClusterExceptionException, CloudControllerServiceKubernetesClusterAlreadyUsedExceptionException {
        this.stub.removeKubernetesCluster(kubernetesClusterId);
    }

    public boolean undeployKubernetesHost(String kubernetesHostId) throws RemoteException, CloudControllerServiceNonExistingKubernetesHostExceptionException {
        return this.stub.removeKubernetesHost(kubernetesHostId);
    }

    public KubernetesHost[] getKubernetesHosts(String kubernetesClusterId) throws RemoteException, CloudControllerServiceNonExistingKubernetesClusterExceptionException {
        return this.stub.getHostsForKubernetesCluster(kubernetesClusterId);
    }

    public KubernetesMaster getKubernetesMaster(String kubernetesClusterId) throws RemoteException, CloudControllerServiceNonExistingKubernetesClusterExceptionException {
        return this.stub.getMasterForKubernetesCluster(kubernetesClusterId);
    }

    public boolean updateKubernetesHost(KubernetesHost kubernetesHost) throws RemoteException, CloudControllerServiceInvalidKubernetesHostExceptionException, CloudControllerServiceNonExistingKubernetesHostExceptionException {
        return this.stub.updateKubernetesHost(kubernetesHost);
    }

    public void validateNetworkPartitionOfDeploymentPolicy(String cartridgeType, String networkPartitionId) throws RemoteException, CloudControllerServiceInvalidPartitionExceptionException, CloudControllerServiceInvalidCartridgeTypeExceptionException {
        this.stub.validateDeploymentPolicyNetworkPartition(cartridgeType, networkPartitionId);
    }

    public void addNetworkPartition(NetworkPartition networkPartition) throws RemoteException, CloudControllerServiceNetworkPartitionAlreadyExistsExceptionException, CloudControllerServiceInvalidNetworkPartitionExceptionException {
        this.stub.addNetworkPartition(networkPartition);
    }

    public void removeNetworkPartition(String networkPartitionId) throws RemoteException, CloudControllerServiceNetworkPartitionNotExistsExceptionException {
        this.stub.removeNetworkPartition(networkPartitionId);
    }

    public void updateNetworkPartition(NetworkPartition networkPartition) throws RemoteException, CloudControllerServiceNetworkPartitionNotExistsExceptionException {
        this.stub.updateNetworkPartition(networkPartition);
    }

    public NetworkPartition[] getNetworkPartitions() throws RemoteException {
        return this.stub.getNetworkPartitions();
    }

    public NetworkPartition getNetworkPartition(String networkPartitionId) throws RemoteException {
        return this.stub.getNetworkPartition(networkPartitionId);
    }

    public void createClusterInstance(String serviceType, String clusterId, String alias, String instanceId, String partitionId, String networkPartitionId) throws RemoteException {
        try {
            this.stub.createClusterInstance(serviceType, clusterId, alias, instanceId, partitionId, networkPartitionId);
        }
        catch (CloudControllerServiceClusterInstanceCreationExceptionException e) {
            String msg = e.getFaultMessage().getClusterInstanceCreationException().getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
    }

    public String[] getIaasProviders() throws RemoteException {
        return this.stub.getIaasProviders();
    }
}

