/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.logging.appenders;

public class CircularBuffer {
    private Object[] buffer;
    private static final int MAX_ALLOWED_SIZE = 10000;
    private int startIndex;
    private int endIndex;

    public CircularBuffer(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Requested size of circular buffer (" + size + ") is invalid");
        }
        if (size > 10000) {
            throw new IllegalArgumentException("Requested size of circular buffer (" + size + ") is greater than the allowed max size " + 10000);
        }
        this.buffer = new Object[size];
        this.startIndex = 0;
        this.endIndex = -1;
    }

    public CircularBuffer() {
        this(10000);
    }

    public synchronized void append(Object obj) {
        if (this.startIndex == this.buffer.length - 1) {
            this.startIndex = 0;
        } else if (this.endIndex == this.buffer.length - 1) {
            this.endIndex = -1;
            this.startIndex = 1;
        } else if (this.startIndex != 0) {
            ++this.startIndex;
        }
        ++this.endIndex;
        this.buffer[this.endIndex] = obj;
    }

    public synchronized Object[] getObjects(int amount) {
        Object[] result;
        if (this.startIndex == 0) {
            if (this.endIndex + 1 >= amount) {
                result = new Object[amount];
                System.arraycopy(this.buffer, 0, result, 0, amount);
            } else {
                result = new Object[this.endIndex + 1];
                System.arraycopy(this.buffer, 0, result, 0, this.endIndex + 1);
            }
        } else if (amount < this.buffer.length) {
            result = new Object[amount];
            if (amount <= this.buffer.length - this.startIndex) {
                System.arraycopy(this.buffer, this.startIndex, result, 0, amount);
            } else {
                System.arraycopy(this.buffer, this.startIndex, result, 0, this.buffer.length - this.startIndex);
                System.arraycopy(this.buffer, 0, result, this.buffer.length - this.startIndex, amount - this.buffer.length + this.startIndex);
            }
        } else {
            result = new Object[this.buffer.length];
            System.arraycopy(this.buffer, this.startIndex, result, 0, this.buffer.length - this.startIndex);
            System.arraycopy(this.buffer, 0, result, this.buffer.length - this.startIndex, this.endIndex + 1);
        }
        return result;
    }

    public synchronized void clear() {
        for (int i = 0; i < this.buffer.length; ++i) {
            this.buffer[i] = null;
        }
        this.startIndex = 0;
        this.endIndex = -1;
    }
}

