/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.processor.cluster.status;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.event.cluster.status.ClusterStatusClusterTerminatedEvent;
import org.apache.stratos.messaging.message.processor.MessageProcessor;
import org.apache.stratos.messaging.message.receiver.topology.TopologyManager;
import org.apache.stratos.messaging.util.MessagingUtil;

public class ClusterStatusClusterTerminatedMessageProcessor
extends MessageProcessor {
    private static final Log log = LogFactory.getLog(ClusterStatusClusterTerminatedMessageProcessor.class);
    private MessageProcessor nextProcessor;

    @Override
    public void setNext(MessageProcessor nextProcessor) {
        this.nextProcessor = nextProcessor;
    }

    @Override
    public boolean process(String type, String message, Object object) {
        if (ClusterStatusClusterTerminatedEvent.class.getName().equals(type)) {
            ClusterStatusClusterTerminatedEvent event = (ClusterStatusClusterTerminatedEvent)MessagingUtil.jsonToObject(message, ClusterStatusClusterTerminatedEvent.class);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Received ClusterStatusClusterTerminatedEvent: " + event.toString()));
            }
            TopologyManager.getTopology().removeFromClusterMap(event.getClusterId());
            this.notifyEventListeners(event);
            return true;
        }
        if (this.nextProcessor != null) {
            return this.nextProcessor.process(type, message, object);
        }
        throw new RuntimeException(String.format("Failed to process cluster activated message using available message processors: [type] %s [body] %s", type, message));
    }
}

