/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.filter.topology;

import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.message.filter.MessageFilter;
import org.apache.stratos.messaging.message.filter.topology.TopologyServiceFilter;

public class TopologyClusterFilter
extends MessageFilter {
    private static final Log log = LogFactory.getLog(TopologyServiceFilter.class);
    public static final String TOPOLOGY_CLUSTER_FILTER_CLUSTER_ID = "cluster-id";
    private static volatile TopologyClusterFilter instance;

    public TopologyClusterFilter() {
        super("stratos.topology.cluster.filter");
    }

    public static boolean apply(String clusterId) {
        boolean excluded = false;
        if (TopologyClusterFilter.getInstance().isActive()) {
            if (StringUtils.isNotBlank((CharSequence)clusterId) && TopologyClusterFilter.getInstance().clusterExcluded(clusterId)) {
                excluded = true;
            }
            if (excluded && log.isInfoEnabled()) {
                log.info((Object)String.format("Cluster is excluded: [cluster-id] %s", clusterId));
            }
        }
        return excluded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TopologyClusterFilter getInstance() {
        if (instance != null) return instance;
        Class<TopologyClusterFilter> clazz = TopologyClusterFilter.class;
        synchronized (TopologyClusterFilter.class) {
            if (instance != null) return instance;
            instance = new TopologyClusterFilter();
            if (!log.isDebugEnabled()) return instance;
            log.debug((Object)"Topology cluster filter instance created");
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private boolean clusterExcluded(String value) {
        return this.excluded(TOPOLOGY_CLUSTER_FILTER_CLUSTER_ID, value);
    }

    private Collection<String> getIncludedClusterIds() {
        return this.getIncludedPropertyValues(TOPOLOGY_CLUSTER_FILTER_CLUSTER_ID);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("cluster-id=");
        for (String clusterId : TopologyClusterFilter.getInstance().getIncludedClusterIds()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(clusterId);
        }
        return sb.toString();
    }
}

