/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.atomiclong;

import com.hazelcast.concurrent.atomiclong.AddBackupOperation;
import com.hazelcast.concurrent.atomiclong.AtomicLongBackupAwareOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.Operation;
import java.io.IOException;

public class GetAndAddOperation
extends AtomicLongBackupAwareOperation {
    private long delta;
    private long returnValue;

    public GetAndAddOperation() {
    }

    public GetAndAddOperation(String name, long delta) {
        super(name);
        this.delta = delta;
    }

    @Override
    public void run() throws Exception {
        this.returnValue = this.getNumber().getAndAdd(this.delta);
    }

    @Override
    public Object getResponse() {
        return this.returnValue;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.delta);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.delta = in.readLong();
    }

    @Override
    public Operation getBackupOperation() {
        return new AddBackupOperation(this.name, this.delta);
    }
}

