/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.framing.amqp_8_0;

import org.apache.mina.common.ByteBuffer;
import org.wso2.andes.AMQException;
import org.wso2.andes.framing.AMQFrameDecodingException;
import org.wso2.andes.framing.AMQMethodBody;
import org.wso2.andes.framing.AMQMethodBodyInstanceFactory;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.framing.FileOpenBody;
import org.wso2.andes.framing.MethodDispatcher;
import org.wso2.andes.framing.amqp_8_0.AMQMethodBody_8_0;
import org.wso2.andes.framing.amqp_8_0.MethodDispatcher_8_0;

public class FileOpenBodyImpl
extends AMQMethodBody_8_0
implements FileOpenBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        public AMQMethodBody newInstance(ByteBuffer in, long size) throws AMQFrameDecodingException {
            return new FileOpenBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 70;
    public static final int METHOD_ID = 40;
    private final AMQShortString _identifier;
    private final long _contentSize;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public FileOpenBodyImpl(ByteBuffer buffer) throws AMQFrameDecodingException {
        this._identifier = this.readAMQShortString(buffer);
        this._contentSize = this.readLong(buffer);
    }

    public FileOpenBodyImpl(AMQShortString identifier, long contentSize) {
        this._identifier = identifier;
        this._contentSize = contentSize;
    }

    public int getClazz() {
        return 70;
    }

    public int getMethod() {
        return 40;
    }

    public final AMQShortString getIdentifier() {
        return this._identifier;
    }

    public final long getContentSize() {
        return this._contentSize;
    }

    protected int getBodySize() {
        int size = 8;
        return size += this.getSizeOf(this._identifier);
    }

    public void writeMethodPayload(ByteBuffer buffer) {
        this.writeAMQShortString(buffer, this._identifier);
        this.writeLong(buffer, this._contentSize);
    }

    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_8_0)dispatcher).dispatchFileOpen(this, channelId);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("[FileOpenBodyImpl: ");
        buf.append("identifier=");
        buf.append(this.getIdentifier());
        buf.append(", ");
        buf.append("contentSize=");
        buf.append(this.getContentSize());
        buf.append("]");
        return buf.toString();
    }
}

