/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core.jdbc.queries;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.config.QueryProcessorConfiguration;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.dataaccess.DataAccessManager;
import org.wso2.carbon.registry.core.dataaccess.QueryProcessor;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

public class QueryProcessorManager {
    private Map<String, QueryProcessor> queryProcessors = new HashMap<String, QueryProcessor>();

    public QueryProcessorManager(DataAccessManager dataAccessManager, RegistryContext registryContext) throws RegistryException {
        this.queryProcessors.put("application/vnd.sql.query", dataAccessManager.getQueryProcessor());
        if (registryContext != null) {
            for (Object queryProcessorObject : registryContext.getQueryProcessors()) {
                String msg;
                QueryProcessorConfiguration configuration = (QueryProcessorConfiguration)queryProcessorObject;
                try {
                    Class<?> qpClass = Class.forName(configuration.getProcessorClassName());
                    Constructor<?> constructor = qpClass.getConstructor(DataAccessManager.class);
                    QueryProcessor queryProcessor = (QueryProcessor)constructor.newInstance(dataAccessManager);
                    this.queryProcessors.put(configuration.getQueryType(), queryProcessor);
                }
                catch (ClassNotFoundException e) {
                    msg = "Could not find the query processor class for query type: " + configuration.getQueryType();
                    throw new RegistryException(msg, e);
                }
                catch (Exception e) {
                    msg = "Failed to initiate query processor for query type: " + configuration.getQueryType();
                    throw new RegistryException(msg, e);
                }
            }
        }
    }

    public QueryProcessor getQueryProcessor(String queryType) {
        return this.queryProcessors.get(queryType);
    }

    public void setQueryProcessor(String queryType, QueryProcessor processor) {
        this.queryProcessors.put(queryType, processor);
    }

    public Collection executeQuery(Registry registry, Resource queryResource, Map parameters) throws RegistryException {
        if (queryResource.getMediaType() == null || queryResource.getMediaType().length() == 0) {
            String msg = "Failed to execute query at path: " + queryResource.getPath() + ". Query resources should have a media type to map to a query processor.";
            throw new RegistryException(msg);
        }
        QueryProcessor queryProcessor = this.queryProcessors.get(queryResource.getMediaType());
        if (queryProcessor == null) {
            String msg = "Failed to execute query at path: " + queryResource.getPath() + ". No query processor is associated with the query type: " + queryResource.getMediaType();
            throw new RegistryException(msg);
        }
        return queryProcessor.executeQuery(registry, queryResource, parameters);
    }
}

