/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.agent.thrift;

import com.google.gson.Gson;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.databridge.agent.thrift.Agent;
import org.wso2.carbon.databridge.agent.thrift.AgentHolder;
import org.wso2.carbon.databridge.agent.thrift.conf.DataPublisherConfiguration;
import org.wso2.carbon.databridge.agent.thrift.conf.ReceiverConfiguration;
import org.wso2.carbon.databridge.agent.thrift.exception.AgentException;
import org.wso2.carbon.databridge.agent.thrift.internal.EventQueue;
import org.wso2.carbon.databridge.agent.thrift.internal.publisher.client.EventPublisher;
import org.wso2.carbon.databridge.agent.thrift.internal.publisher.client.EventPublisherFactory;
import org.wso2.carbon.databridge.agent.thrift.internal.utils.AgentServerURL;
import org.wso2.carbon.databridge.agent.thrift.lb.ReceiverStateObserver;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.databridge.commons.StreamDefinition;
import org.wso2.carbon.databridge.commons.exception.AuthenticationException;
import org.wso2.carbon.databridge.commons.exception.DifferentStreamDefinitionAlreadyDefinedException;
import org.wso2.carbon.databridge.commons.exception.MalformedStreamDefinitionException;
import org.wso2.carbon.databridge.commons.exception.NoStreamDefinitionExistException;
import org.wso2.carbon.databridge.commons.exception.StreamDefinitionException;
import org.wso2.carbon.databridge.commons.exception.TransportException;
import org.wso2.carbon.databridge.commons.thrift.utils.HostAddressFinder;

public class DataPublisher {
    private static Log log = LogFactory.getLog(DataPublisher.class);
    private DataPublisherConfiguration dataPublisherConfiguration;
    private EventPublisher eventPublisher;
    private EventQueue<Event> eventQueue;
    private Gson gson = new Gson();
    private ThreadPoolExecutor threadPool;
    private ReceiverStateObserver receiverStateObserver;

    public DataPublisher(String receiverUrl, String userName, String password) throws MalformedURLException, AgentException, AuthenticationException, TransportException {
        this(receiverUrl, userName, password, AgentHolder.getOrCreateAgent());
    }

    public DataPublisher(String authenticationUrl, String receiverUrl, String userName, String password) throws MalformedURLException, AgentException, AuthenticationException, TransportException {
        this(authenticationUrl, receiverUrl, userName, password, AgentHolder.getOrCreateAgent());
    }

    public DataPublisher(String receiverUrl, String userName, String password, Agent agent) throws MalformedURLException, AgentException, AuthenticationException, TransportException {
        if (null == agent) {
            agent = AgentHolder.getOrCreateAgent();
        } else if (AgentHolder.getAgent() == null) {
            AgentHolder.setAgent(agent);
        }
        AgentServerURL receiverURL = new AgentServerURL(receiverUrl);
        this.checkHostAddress(receiverURL.getHost());
        if (receiverURL.isSecured()) {
            this.start(new ReceiverConfiguration(userName, password, receiverURL.getProtocol(), receiverURL.getHost(), receiverURL.getPort(), receiverURL.getProtocol(), receiverURL.getHost(), receiverURL.getPort(), receiverURL.isSecured()), AgentHolder.getAgent());
        } else if (receiverURL.getProtocol() == ReceiverConfiguration.Protocol.TCP) {
            this.start(new ReceiverConfiguration(userName, password, receiverURL.getProtocol(), receiverURL.getHost(), receiverURL.getPort(), receiverURL.getProtocol(), receiverURL.getHost(), receiverURL.getPort() + 100, receiverURL.isSecured()), AgentHolder.getAgent());
        } else {
            throw new AgentException("http not supported via this constructor use https, ssl or tcp ");
        }
    }

    public DataPublisher(String authenticationUrl, String receiverUrl, String userName, String password, Agent agent) throws MalformedURLException, AgentException, AuthenticationException, TransportException {
        if (null == agent) {
            agent = AgentHolder.getOrCreateAgent();
        } else if (AgentHolder.getAgent() == null) {
            AgentHolder.setAgent(agent);
        }
        AgentServerURL authenticationURL = new AgentServerURL(authenticationUrl);
        if (!authenticationURL.isSecured()) {
            throw new MalformedURLException("Authentication url protocol is not ssl/https, expected = <ssl/https>://<HOST>:<PORT> but actual = " + authenticationUrl);
        }
        AgentServerURL receiverURL = new AgentServerURL(receiverUrl);
        this.checkHostAddress(receiverURL.getHost());
        this.checkHostAddress(authenticationURL.getHost());
        this.start(new ReceiverConfiguration(userName, password, receiverURL.getProtocol(), receiverURL.getHost(), receiverURL.getPort(), authenticationURL.getProtocol(), authenticationURL.getHost(), authenticationURL.getPort(), receiverURL.isSecured()), AgentHolder.getAgent());
    }

    private void checkHostAddress(String hostAddress) throws AgentException {
        try {
            HostAddressFinder.findAddress((String)hostAddress);
        }
        catch (SocketException e) {
            throw new AgentException(hostAddress + " is malformed ", e);
        }
    }

    public void setAgent(Agent agent) throws AgentException, AuthenticationException, TransportException {
        AgentHolder.getAgent().shutdown(this);
        AgentHolder.setAgent(agent);
        this.start(this.dataPublisherConfiguration.getReceiverConfiguration(), agent);
        if (null != this.receiverStateObserver) {
            this.eventPublisher.registerReceiverStateObserver(this.receiverStateObserver);
        }
    }

    public Agent getAgent() {
        return AgentHolder.getAgent();
    }

    public void registerReceiverStateObserver(ReceiverStateObserver stateObserver) {
        this.receiverStateObserver = stateObserver;
        this.eventPublisher.registerReceiverStateObserver(this.receiverStateObserver);
    }

    private void start(ReceiverConfiguration receiverConfiguration, Agent agent) throws AgentException, AuthenticationException, TransportException {
        agent.addDataPublisher(this);
        this.dataPublisherConfiguration = new DataPublisherConfiguration(receiverConfiguration);
        this.eventQueue = new EventQueue();
        this.threadPool = agent.getThreadPool();
        this.eventPublisher = receiverConfiguration.isDataTransferSecured() ? EventPublisherFactory.getEventPublisher(this.dataPublisherConfiguration, this.eventQueue, agent, agent.getSecureTransportPool()) : EventPublisherFactory.getEventPublisher(this.dataPublisherConfiguration, this.eventQueue, agent, agent.getTransportPool());
        this.dataPublisherConfiguration.setSessionId(agent.getAgentAuthenticator().connect(this.dataPublisherConfiguration));
    }

    public String defineStream(String streamDefinition) throws AgentException, MalformedStreamDefinitionException, StreamDefinitionException, DifferentStreamDefinitionAlreadyDefinedException {
        String sessionId = this.dataPublisherConfiguration.getSessionId();
        return this.eventPublisher.defineStream(sessionId, streamDefinition);
    }

    public String defineStream(StreamDefinition streamDefinition) throws AgentException, MalformedStreamDefinitionException, StreamDefinitionException, DifferentStreamDefinitionAlreadyDefinedException {
        String sessionId = this.dataPublisherConfiguration.getSessionId();
        String streamId = this.eventPublisher.defineStream(sessionId, this.gson.toJson((Object)streamDefinition));
        try {
            Field field = StreamDefinition.class.getDeclaredField("streamId");
            field.setAccessible(true);
            field.set(streamDefinition, streamId);
        }
        catch (NoSuchFieldException e) {
        }
        catch (IllegalAccessException e) {
            // empty catch block
        }
        return streamId;
    }

    @Deprecated
    public String findStream(String name, String version) throws AgentException, StreamDefinitionException, NoStreamDefinitionExistException {
        String streamId = this.findStreamId(name, version);
        if (streamId == null) {
            throw new NoStreamDefinitionExistException("Cannot find Stream Id for " + name + " " + version);
        }
        return streamId;
    }

    public String findStreamId(String name, String version) throws AgentException {
        String sessionId = this.dataPublisherConfiguration.getSessionId();
        return this.eventPublisher.findStreamId(sessionId, name, version);
    }

    public boolean deleteStream(String streamId) throws AgentException {
        String sessionId = this.dataPublisherConfiguration.getSessionId();
        return this.eventPublisher.deleteStream(sessionId, streamId);
    }

    public boolean deleteStream(String streamName, String streamVersion) throws AgentException {
        String sessionId = this.dataPublisherConfiguration.getSessionId();
        return this.eventPublisher.deleteStream(sessionId, streamName, streamVersion);
    }

    public void publish(Event event) throws AgentException {
        try {
            AgentHolder.getAgent().getQueueSemaphore().acquire();
            if (!this.eventQueue.put(event)) {
                try {
                    this.threadPool.execute(this.eventPublisher);
                }
                catch (RejectedExecutionException ignored) {}
            }
        }
        catch (InterruptedException e) {
            throw new AgentException("Cannot add " + event + " to event queue", e);
        }
    }

    public void publish(String streamId, Object[] metaDataArray, Object[] correlationDataArray, Object[] payloadDataArray) throws AgentException {
        this.publish(new Event(streamId, System.currentTimeMillis(), metaDataArray, correlationDataArray, payloadDataArray));
    }

    public void publish(String streamId, Object[] metaDataArray, Object[] correlationDataArray, Object[] payloadDataArray, Map<String, String> arbitraryDataMap) throws AgentException {
        this.publish(new Event(streamId, System.currentTimeMillis(), metaDataArray, correlationDataArray, payloadDataArray, arbitraryDataMap));
    }

    public void publish(String streamId, long timeStamp, Object[] metaDataArray, Object[] correlationDataArray, Object[] payloadDataArray) throws AgentException {
        this.publish(new Event(streamId, timeStamp, metaDataArray, correlationDataArray, payloadDataArray));
    }

    public void publish(String streamId, long timeStamp, Object[] metaDataArray, Object[] correlationDataArray, Object[] payloadDataArray, Map<String, String> arbitraryDataMap) throws AgentException {
        this.publish(new Event(streamId, timeStamp, metaDataArray, correlationDataArray, payloadDataArray, arbitraryDataMap));
    }

    public void stop() {
        AgentHolder.getAgent().getAgentAuthenticator().disconnect(this.dataPublisherConfiguration);
        AgentHolder.getAgent().shutdown(this);
    }

    public void stopNow() {
        AgentHolder.getAgent().getAgentAuthenticator().disconnect(this.dataPublisherConfiguration);
        AgentHolder.getAgent().shutdownNow(this);
    }
}

