/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.message.impl;

import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.ws.WebServiceException;
import org.apache.axiom.om.OMDataSourceExt;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.ds.ByteArrayDataSource;
import org.apache.axiom.om.impl.MTOMXMLStreamWriter;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.message.Block;
import org.apache.axis2.jaxws.message.Message;
import org.apache.axis2.jaxws.message.factory.BlockFactory;
import org.apache.axis2.jaxws.message.util.Reader2Writer;
import org.apache.axis2.jaxws.utility.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BlockImpl
implements Block {
    private static Log log = LogFactory.getLog(BlockImpl.class);
    protected Object busObject;
    protected Object busContext;
    protected OMElement omElement = null;
    protected QName qName;
    private boolean noQNameAvailable = false;
    protected BlockFactory factory;
    protected boolean consumed = false;
    protected Message parent;
    private HashMap map = null;

    protected BlockImpl(Object busObject, Object busContext, QName qName, BlockFactory factory) {
        this.busObject = busObject;
        this.busContext = busContext;
        this.qName = qName;
        this.factory = factory;
    }

    protected BlockImpl(OMElement omElement, Object busContext, QName qName, BlockFactory factory) {
        this.omElement = omElement;
        this.busContext = busContext;
        this.qName = qName;
        this.factory = factory;
    }

    @Override
    public BlockFactory getBlockFactory() {
        return this.factory;
    }

    @Override
    public Object getBusinessContext() {
        return this.busContext;
    }

    @Override
    public Message getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Message p) {
        this.parent = p;
    }

    @Override
    public Object getBusinessObject(boolean consume) throws XMLStreamException, WebServiceException {
        if (this.consumed) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("BlockImplErr1", this.getClass().getName()));
        }
        if (this.busObject != null) {
            this.busObject = this._getBOFromBO(this.busObject, this.busContext, consume);
        } else {
            this.busObject = this._getBOFromOM(this.omElement, this.busContext);
            this.omElement = null;
        }
        Object newBusObject = this.busObject;
        this.setConsumed(consume);
        return newBusObject;
    }

    @Override
    public QName getQName() throws WebServiceException {
        try {
            if (this.qName == null) {
                if (this.noQNameAvailable) {
                    return null;
                }
                if (this.omElement == null) {
                    try {
                        XMLStreamReader newReader = this._getReaderFromBO(this.busObject, this.busContext);
                        this.busObject = null;
                        StAXOMBuilder builder = new StAXOMBuilder(newReader);
                        this.omElement = builder.getDocumentElement();
                        this.omElement.close(true);
                    }
                    catch (Exception e) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Exception occurred while obtaining QName:" + e));
                        }
                        if (!this.isElementData()) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"The block does not contain an xml element. Processing continues.");
                            }
                            this.noQNameAvailable = true;
                            return null;
                        }
                        throw ExceptionFactory.makeWebServiceException(e);
                    }
                }
                this.qName = this.omElement.getQName();
            }
            return this.qName;
        }
        catch (Exception xse) {
            this.setConsumed(true);
            throw ExceptionFactory.makeWebServiceException(xse);
        }
    }

    protected void setQName(QName qName) {
        this.qName = qName;
    }

    @Override
    public XMLStreamReader getXMLStreamReader(boolean consume) throws XMLStreamException, WebServiceException {
        XMLStreamReader newReader = null;
        if (this.consumed) {
            if (this.getParent() != null && this.getParent().isPostPivot()) {
                return this._postPivot_getXMLStreamReader();
            }
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("BlockImplErr1", this.getClass().getName()));
        }
        if (this.omElement != null) {
            if (consume) {
                newReader = this.omElement.getBuilder() != null && !this.omElement.getBuilder().isCompleted() ? this.omElement.getXMLStreamReaderWithoutCaching() : this.omElement.getXMLStreamReader();
                this.omElement = null;
            } else {
                newReader = this.omElement.getXMLStreamReader();
            }
        } else if (this.busObject != null) {
            this.busObject = this._getBOFromBO(this.busObject, this.busContext, consume);
            newReader = this._getReaderFromBO(this.busObject, this.busContext);
        }
        this.setConsumed(consume);
        return newReader;
    }

    public XMLStreamReader getReader() throws XMLStreamException {
        return this.getXMLStreamReader(true);
    }

    public void serialize(OutputStream output, OMOutputFormat format) throws XMLStreamException {
        block2: {
            MTOMXMLStreamWriter writer = new MTOMXMLStreamWriter(output, format);
            this.serialize((XMLStreamWriter)writer);
            writer.flush();
            try {
                writer.close();
            }
            catch (XMLStreamException e) {
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)("Catching and swallowing exception " + e));
            }
        }
    }

    public void serialize(Writer writerTarget, OMOutputFormat format) throws XMLStreamException {
        MTOMXMLStreamWriter writer = new MTOMXMLStreamWriter(StAXUtils.createXMLStreamWriter((Writer)writerTarget));
        writer.setOutputFormat(format);
        this.serialize((XMLStreamWriter)writer);
        writer.flush();
        writer.close();
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        this.outputTo(writer, this.isDestructiveWrite());
    }

    @Override
    public OMElement getOMElement() throws XMLStreamException, WebServiceException {
        OMElement newOMElement = null;
        boolean consume = true;
        if (this.consumed) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("BlockImplErr1", this.getClass().getName()));
        }
        if (this.omElement != null) {
            newOMElement = this.omElement;
        } else if (this.busObject != null) {
            this.busObject = this._getBOFromBO(this.busObject, this.busContext, consume);
            newOMElement = this._getOMFromBO(this.busObject, this.busContext);
        }
        this.setConsumed(consume);
        return newOMElement;
    }

    @Override
    public boolean isConsumed() {
        return this.consumed;
    }

    public void setConsumed(boolean consume) {
        if (consume) {
            this.consumed = true;
            this.busObject = null;
            this.busContext = null;
            this.omElement = null;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Message Block Monitor: Action=Consumed");
                log.trace((Object)JavaUtils.stackToString());
            }
        } else {
            this.consumed = false;
        }
    }

    @Override
    public boolean isQNameAvailable() {
        return this.qName != null;
    }

    @Override
    public void outputTo(XMLStreamWriter writer, boolean consume) throws XMLStreamException, WebServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start outputTo");
        }
        if (this.consumed) {
            if (this.getParent() != null && this.getParent().isPostPivot()) {
                this._postPivot_outputTo(writer);
            }
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("BlockImplErr1", this.getClass().getName()));
        }
        if (this.omElement != null) {
            this._outputFromOM(this.omElement, writer, consume);
        } else if (this.busObject != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Write business object");
            }
            this.busObject = this._getBOFromBO(this.busObject, this.busContext, consume);
            this._outputFromBO(this.busObject, this.busContext, writer);
        }
        this.setConsumed(consume);
        if (log.isDebugEnabled()) {
            log.debug((Object)"End outputTo");
        }
    }

    protected void _postPivot_outputTo(XMLStreamWriter writer) throws XMLStreamException, WebServiceException {
        if (log.isDebugEnabled()) {
            QName theQName = this.isQNameAvailable() ? this.getQName() : new QName("unknown");
            log.debug((Object)("The Block for " + theQName + " is already consumed and therefore it is not written."));
            log.debug((Object)"If you need this block preserved, please set the org.apache.axis2.jaxws.spi.SAVE_REQUEST_MSG property on the MessageContext.");
        }
    }

    protected XMLStreamReader _postPivot_getXMLStreamReader() throws XMLStreamException, WebServiceException {
        if (log.isDebugEnabled()) {
            QName theQName = this.isQNameAvailable() ? this.getQName() : new QName("unknown");
            log.debug((Object)("The Block for " + theQName + " is already consumed and therefore it is only partially read."));
            log.debug((Object)"If you need this block preserved, please set the org.apache.axis2.jaxws.spi.SAVE_REQUEST_MSG property on the MessageContext.");
        }
        QName qName = this.getQName();
        String text = "";
        text = qName.getNamespaceURI().length() > 0 ? "<prefix:" + qName.getLocalPart() + " xmlns:prefix='" + qName.getNamespaceURI() + "'/>" : "<" + qName.getLocalPart() + "/>";
        StringReader sr = new StringReader(text);
        return StAXUtils.createXMLStreamReader((Reader)sr);
    }

    protected boolean isBusinessObject() {
        return this.busObject != null;
    }

    @Override
    public String traceString(String indent) {
        return null;
    }

    protected Object _getBOFromBO(Object busObject, Object busContext, boolean consume) {
        return busObject;
    }

    protected abstract Object _getBOFromReader(XMLStreamReader var1, Object var2) throws XMLStreamException, WebServiceException;

    protected Object _getBOFromOM(OMElement omElement, Object busContext) throws XMLStreamException, WebServiceException {
        XMLStreamReader reader = this._getReaderFromOM(omElement);
        return this._getBOFromReader(reader, busContext);
    }

    protected abstract XMLStreamReader _getReaderFromBO(Object var1, Object var2) throws XMLStreamException, WebServiceException;

    protected XMLStreamReader _getReaderFromOM(OMElement omElement) {
        XMLStreamReader reader = omElement.getBuilder() != null && !omElement.getBuilder().isCompleted() ? omElement.getXMLStreamReaderWithoutCaching() : omElement.getXMLStreamReader();
        return reader;
    }

    protected OMElement _getOMFromBO(Object busObject, Object busContext) throws XMLStreamException, WebServiceException {
        XMLStreamReader newReader = this._getReaderFromBO(busObject, busContext);
        StAXOMBuilder builder = new StAXOMBuilder(newReader);
        return builder.getDocumentElement();
    }

    protected void _outputFromReader(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        Reader2Writer r2w = new Reader2Writer(reader);
        r2w.outputTo(writer);
    }

    protected void _outputFromOM(OMElement omElement, XMLStreamWriter writer, boolean consume) throws XMLStreamException {
        if (consume) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Write using OMElement.serializeAndConsume");
            }
            omElement.serializeAndConsume(writer);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Write Using OMElement.serialize");
            }
            omElement.serialize(writer);
        }
    }

    public OMDataSourceExt copy() throws OMException {
        try {
            String encoding = "utf-8";
            byte[] bytes = this.getXMLBytes(encoding);
            return new ByteArrayDataSource(bytes, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new OMException((Throwable)e);
        }
    }

    protected abstract void _outputFromBO(Object var1, Object var2, XMLStreamWriter var3) throws XMLStreamException, WebServiceException;

    public Object getProperty(String key) {
        if (this.map == null) {
            return null;
        }
        return this.map.get(key);
    }

    public Object setProperty(String key, Object value) {
        if (this.map == null) {
            this.map = new HashMap();
        }
        return this.map.put(key, value);
    }

    public boolean hasProperty(String key) {
        if (this.map == null) {
            return false;
        }
        return this.map.containsKey(key);
    }
}

