/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.lifecycle;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.lifecycle.LifecycleException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BaseLifecycleManager {
    private static final Log log = LogFactory.getLog(BaseLifecycleManager.class);
    protected Object instance;

    public void invokePostConstruct() throws LifecycleException {
        if (this.instance == null) {
            throw new LifecycleException(Messages.getMessage("EndpointLifecycleManagerImplErr1"));
        }
        Method method = this.getPostConstructMethod();
        if (method != null) {
            this.invokePostConstruct(method);
        }
    }

    protected void invokePostConstruct(final Method method) throws LifecycleException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Invoking Method with @PostConstruct annotation");
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws InvocationTargetException, IllegalAccessException {
                    if (!method.isAccessible()) {
                        method.setAccessible(true);
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new LifecycleException(e.getException());
        }
        this.invokeMethod(method, null);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Completed invoke on Method with @PostConstruct annotation");
        }
    }

    public void invokePreDestroy() throws LifecycleException {
        if (this.instance == null) {
            throw new LifecycleException(Messages.getMessage("EndpointLifecycleManagerImplErr1"));
        }
        Method method = this.getPreDestroyMethod();
        if (method != null) {
            this.invokePreDestroy(method);
        }
    }

    protected void invokePreDestroy(Method method) throws LifecycleException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Invoking Method with @PreDestroy annotation");
        }
        this.invokeMethod(method, null);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Completed invoke on Method with @PreDestroy annotation");
        }
    }

    protected void invokeMethod(final Method m, final Object[] params) throws LifecycleException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws InvocationTargetException, IllegalAccessException {
                    return m.invoke(BaseLifecycleManager.this.instance, params);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new LifecycleException(e.getException());
        }
    }

    protected Method getPostConstructMethod() {
        if (this.instance != null) {
            Method[] methods;
            final Class<?> endpointClazz = this.instance.getClass();
            for (Method method : methods = (Method[])AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return endpointClazz.getMethods();
                }
            })) {
                if (!this.isPostConstruct(method)) continue;
                return method;
            }
        }
        return null;
    }

    protected Method getPreDestroyMethod() {
        if (this.instance != null) {
            Method[] methods;
            final Class<?> endpointClazz = this.instance.getClass();
            for (Method method : methods = (Method[])AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return endpointClazz.getMethods();
                }
            })) {
                if (!this.isPreDestroy(method)) continue;
                return method;
            }
        }
        return null;
    }

    protected boolean isPostConstruct(final Method method) {
        int i$ = 0;
        Annotation[] annotations = (Annotation[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return method.getDeclaredAnnotations();
            }
        });
        Annotation[] arr$ = annotations;
        int len$ = arr$.length;
        if (i$ < len$) {
            Annotation annotation = arr$[i$];
            return PostConstruct.class.isAssignableFrom(annotation.annotationType());
        }
        return false;
    }

    protected boolean isPreDestroy(final Method method) {
        int i$ = 0;
        Annotation[] annotations = (Annotation[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return method.getDeclaredAnnotations();
            }
        });
        Annotation[] arr$ = annotations;
        int len$ = arr$.length;
        if (i$ < len$) {
            Annotation annotation = arr$[i$];
            return PreDestroy.class.isAssignableFrom(annotation.annotationType());
        }
        return false;
    }
}

