/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store.jdbc;

import java.util.Properties;
import org.apache.lucene.store.jdbc.handler.MarkDeleteFileEntryHandler;
import org.apache.lucene.store.jdbc.index.FetchOnBufferReadJdbcIndexInput;
import org.apache.lucene.store.jdbc.index.RAMAndFileJdbcIndexOutput;

public class JdbcFileEntrySettings {
    public static final String INDEX_INPUT_TYPE_SETTING = "indexInput.type";
    public static final String INDEX_OUTPUT_TYPE_SETTING = "indexOutput.type";
    public static final String FILE_ENTRY_HANDLER_TYPE = "type";
    private Properties settings = new Properties();

    public JdbcFileEntrySettings() {
        this.setClassSetting(FILE_ENTRY_HANDLER_TYPE, MarkDeleteFileEntryHandler.class);
        this.setClassSetting(INDEX_INPUT_TYPE_SETTING, FetchOnBufferReadJdbcIndexInput.class);
        this.setClassSetting(INDEX_OUTPUT_TYPE_SETTING, RAMAndFileJdbcIndexOutput.class);
    }

    public Properties getProperties() {
        return this.settings;
    }

    public String getSetting(String setting) {
        return this.settings.getProperty(setting);
    }

    public String getSetting(String setting, String defaultValue) {
        return this.settings.getProperty(setting, defaultValue);
    }

    public float getSettingAsFloat(String setting, float defaultValue) {
        String sValue = this.getSetting(setting);
        if (sValue == null) {
            return defaultValue;
        }
        return Float.parseFloat(sValue);
    }

    public int getSettingAsInt(String setting, int defaultValue) {
        String sValue = this.getSetting(setting);
        if (sValue == null) {
            return defaultValue;
        }
        return Integer.parseInt(sValue);
    }

    public long getSettingAsLong(String setting, long defaultValue) {
        String sValue = this.getSetting(setting);
        if (sValue == null) {
            return defaultValue;
        }
        return Long.parseLong(sValue);
    }

    public Class getSettingAsClass(String setting, Class defaultValue) throws ClassNotFoundException {
        return this.getSettingAsClass(setting, defaultValue, Thread.currentThread().getContextClassLoader());
    }

    public Class getSettingAsClass(String setting, Class defaultValue, ClassLoader classLoader) throws ClassNotFoundException {
        String sValue = this.getSetting(setting);
        if (sValue == null) {
            return defaultValue;
        }
        return Class.forName(sValue, true, classLoader);
    }

    public boolean getSettingAsBoolean(String setting, boolean defaultValue) {
        String sValue = this.getSetting(setting);
        if (sValue == null) {
            return defaultValue;
        }
        return Boolean.valueOf(sValue);
    }

    public JdbcFileEntrySettings setSetting(String setting, String value) {
        this.settings.setProperty(setting, value);
        return this;
    }

    public JdbcFileEntrySettings setBooleanSetting(String setting, boolean value) {
        this.setSetting(setting, String.valueOf(value));
        return this;
    }

    public JdbcFileEntrySettings setFloatSetting(String setting, float value) {
        this.setSetting(setting, String.valueOf(value));
        return this;
    }

    public JdbcFileEntrySettings setIntSetting(String setting, int value) {
        this.setSetting(setting, String.valueOf(value));
        return this;
    }

    public JdbcFileEntrySettings setLongSetting(String setting, long value) {
        this.setSetting(setting, String.valueOf(value));
        return this;
    }

    public JdbcFileEntrySettings setClassSetting(String setting, Class clazz) {
        this.setSetting(setting, clazz.getName());
        return this;
    }
}

