/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.common.Property;

public class Properties
implements Serializable {
    private static final long serialVersionUID = -9094584151615076171L;
    private static final Log log = LogFactory.getLog(Properties.class);
    private List<Property> properties = new ArrayList<Property>();

    public Property[] getProperties() {
        return this.properties.toArray(new Property[this.properties.size()]);
    }

    public void addProperty(Property property) {
        try {
            this.properties.add((Property)property.clone());
        }
        catch (CloneNotSupportedException e) {
            log.error((Object)e);
        }
    }

    public Property getProperty(String name) {
        for (Property property : this.properties) {
            if (!property.getName().equals(name)) continue;
            return property;
        }
        return null;
    }

    public void setProperties(Property[] properties) {
        this.properties = new ArrayList<Property>();
        Collections.addAll(this.properties, (Object[])properties.clone());
    }

    public String toString() {
        return "Properties [properties=" + this.properties + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Properties other = (Properties)obj;
        return !(this.properties == null ? other.properties != null : !Arrays.equals(other.getProperties(), this.getProperties()));
    }
}

