/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.securevault;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import org.apache.axiom.util.base64.Base64Utils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.securevault.EncodingType;
import org.wso2.securevault.commons.MiscellaneousUtil;

public final class EncodingHelper {
    private static Log log = LogFactory.getLog(EncodingHelper.class);

    private EncodingHelper() {
    }

    public static byte[] encode(ByteArrayOutputStream baos, EncodingType encodingType) {
        switch (encodingType) {
            case BASE64: {
                if (log.isDebugEnabled()) {
                    log.debug("base64 encoding on output ");
                }
                return Base64Utils.encode((byte[])baos.toByteArray()).getBytes();
            }
            case BIGINTEGER16: {
                if (log.isDebugEnabled()) {
                    log.debug("BigInteger 16 encoding on output ");
                }
                return new BigInteger(baos.toByteArray()).toByteArray();
            }
        }
        throw new IllegalArgumentException("Unsupported encoding type");
    }

    public static InputStream decode(InputStream inputStream, EncodingType encodingType) throws IOException {
        ByteArrayInputStream decodedInputStream = null;
        switch (encodingType) {
            case BASE64: {
                if (log.isDebugEnabled()) {
                    log.debug("base64 decoding on input  ");
                }
                decodedInputStream = new ByteArrayInputStream(Base64Utils.decode((String)new String(MiscellaneousUtil.asBytes(inputStream))));
                break;
            }
            case BIGINTEGER16: {
                if (log.isDebugEnabled()) {
                    log.debug("BigInteger 16 encoding on output ");
                }
                BigInteger n = new BigInteger(IOUtils.toString((InputStream)inputStream), 16);
                decodedInputStream = new ByteArrayInputStream(n.toByteArray());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported encoding type");
            }
        }
        return decodedInputStream;
    }
}

