/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.util;

import java.util.Map;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.impl.builder.StAXBuilder;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.builder.XOPAwareStAXOMBuilder;
import org.apache.axiom.soap.impl.builder.MTOMStAXSOAPModelBuilder;
import org.apache.axiom.soap.impl.builder.StAXSOAPModelBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.Builder;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.transport.http.ApplicationXMLFormatter;
import org.apache.axis2.transport.http.SOAPMessageFormatter;
import org.apache.axis2.transport.http.XFormURLEncodedFormatter;
import org.apache.axis2.util.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MessageProcessorSelector {
    private static final Log log = LogFactory.getLog(MessageProcessorSelector.class);

    public static Builder getMessageBuilder(String type, MessageContext msgContext) throws AxisFault {
        String cType;
        Builder builder;
        boolean useFallbackBuilder = false;
        AxisConfiguration configuration = msgContext.getConfigurationContext().getAxisConfiguration();
        Parameter useFallbackParameter = configuration.getParameter("useDefaultFallbackBuilder");
        if (useFallbackParameter != null) {
            useFallbackBuilder = JavaUtils.isTrueExplicitly(useFallbackParameter.getValue(), useFallbackBuilder);
        }
        if ((builder = configuration.getMessageBuilder(cType = MessageProcessorSelector.getContentTypeForBuilderSelection(type, msgContext), useFallbackBuilder)) != null) {
            String acceptHeader;
            Map transportHeaders;
            Object contentNegotiation = configuration.getParameterValue("httpContentNegotiation");
            if (JavaUtils.isTrueExplicitly(contentNegotiation) && (transportHeaders = (Map)msgContext.getProperty("TRANSPORT_HEADERS")) != null && (acceptHeader = (String)transportHeaders.get("Accept")) != null) {
                String[] strings;
                int index = acceptHeader.indexOf(";");
                if (index > 0) {
                    acceptHeader = acceptHeader.substring(0, index);
                }
                for (String string : strings = acceptHeader.split(",")) {
                    String accept = string.trim();
                    if ("text/xml".equals(accept) || configuration.getMessageFormatter(accept) == null) continue;
                    type = string;
                    break;
                }
            }
            msgContext.setProperty("messageType", type);
        }
        return builder;
    }

    public static MessageFormatter getMessageFormatter(MessageContext msgContext) throws AxisFault {
        MessageFormatter messageFormatter = null;
        String messageFormatString = MessageProcessorSelector.getMessageFormatterProperty(msgContext);
        if ((messageFormatString = MessageProcessorSelector.getContentTypeForFormatterSelection(messageFormatString, msgContext)) != null) {
            messageFormatter = msgContext.getConfigurationContext().getAxisConfiguration().getMessageFormatter(messageFormatString);
            if (log.isDebugEnabled()) {
                log.debug("Message format is: " + messageFormatString + "; message formatter returned by AxisConfiguration: " + messageFormatter);
            }
        }
        if (messageFormatter == null && (messageFormatter = (MessageFormatter)msgContext.getProperty("messageFormatter")) != null) {
            return messageFormatter;
        }
        if (messageFormatter == null) {
            if (msgContext.isDoingREST()) {
                String httpMethod = (String)msgContext.getProperty("HTTP_METHOD");
                if ("GET".equals(httpMethod) || "DELETE".equals(httpMethod)) {
                    return new XFormURLEncodedFormatter();
                }
                return new ApplicationXMLFormatter();
            }
            messageFormatter = new SOAPMessageFormatter();
        }
        return messageFormatter;
    }

    public static StAXBuilder getAttachmentBuilder(MessageContext msgContext, Attachments attachments, XMLStreamReader streamReader, String soapEnvelopeNamespaceURI, boolean isSOAP) throws OMException, XMLStreamException, FactoryConfigurationError {
        XOPAwareStAXOMBuilder builder = null;
        if (isSOAP) {
            if (attachments.getAttachmentSpecType().equals("application/xop+xml")) {
                builder = new MTOMStAXSOAPModelBuilder(streamReader, attachments, soapEnvelopeNamespaceURI);
                msgContext.setDoingMTOM(true);
            } else if (attachments.getAttachmentSpecType().equals("text/xml")) {
                builder = new StAXSOAPModelBuilder(streamReader, soapEnvelopeNamespaceURI);
            } else if (attachments.getAttachmentSpecType().equals("application/soap+xml")) {
                builder = new StAXSOAPModelBuilder(streamReader, soapEnvelopeNamespaceURI);
            }
        } else if (attachments.getAttachmentSpecType().equals("application/xop+xml")) {
            builder = new XOPAwareStAXOMBuilder(streamReader, attachments);
        } else if (attachments.getAttachmentSpecType().equals("text/xml")) {
            builder = new StAXOMBuilder(streamReader);
        } else if (attachments.getAttachmentSpecType().equals("application/soap+xml")) {
            builder = new StAXOMBuilder(streamReader);
        }
        return builder;
    }

    private static String getMessageFormatterProperty(MessageContext msgContext) {
        Parameter parameter;
        String messageFormatterProperty = null;
        Object property = msgContext.getProperty("messageType");
        if (property != null) {
            messageFormatterProperty = (String)property;
        }
        if (messageFormatterProperty == null && (parameter = msgContext.getParameter("messageType")) != null) {
            messageFormatterProperty = (String)parameter.getValue();
        }
        return messageFormatterProperty;
    }

    private static String getContentTypeForBuilderSelection(String type, MessageContext msgContext) {
        String cType = type;
        if (msgContext.getSoapAction() == null && "text/xml".equals(type) && msgContext.isDoingREST()) {
            cType = "application/xml";
        }
        return cType;
    }

    private static String getContentTypeForFormatterSelection(String type, MessageContext msgContext) {
        String cType = type;
        if (msgContext.isDoingREST() && "text/xml".equals(type)) {
            cType = "application/xml";
            msgContext.setProperty("ContentType", "text/xml");
        }
        return cType;
    }
}

