/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.sw;

import com.ctc.wstx.compat.QNameCreator;
import com.ctc.wstx.util.BijectiveNsMap;
import com.ctc.wstx.util.EmptyIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class SimpleOutputElement
implements NamespaceContext {
    public static final int PREFIX_UNBOUND = 0;
    public static final int PREFIX_OK = 1;
    public static final int PREFIX_MISBOUND = 2;
    static final String sXmlNsPrefix = "xml";
    static final String sXmlNsURI = "http://www.w3.org/XML/1998/namespace";
    SimpleOutputElement mParent;
    String mPrefix;
    String mLocalName;
    String mURI;
    NamespaceContext mRootNsContext;
    String mDefaultNsURI;
    boolean mDefaultNsSet;
    BijectiveNsMap mNsMapping;
    boolean mNsMapShared;
    HashMap mAttrMap = null;

    private SimpleOutputElement() {
        this.mParent = null;
        this.mPrefix = null;
        this.mLocalName = "";
        this.mURI = null;
        this.mNsMapping = null;
        this.mNsMapShared = false;
        this.mDefaultNsURI = "";
        this.mRootNsContext = null;
        this.mDefaultNsSet = false;
    }

    private SimpleOutputElement(SimpleOutputElement parent, String prefix, String localName, String uri, BijectiveNsMap ns) {
        this.mParent = parent;
        this.mPrefix = prefix;
        this.mLocalName = localName;
        this.mURI = uri;
        this.mNsMapping = ns;
        this.mNsMapShared = ns != null;
        this.mDefaultNsURI = parent.mDefaultNsURI;
        this.mRootNsContext = parent.mRootNsContext;
        this.mDefaultNsSet = false;
    }

    private void relink(SimpleOutputElement parent, String prefix, String localName, String uri) {
        this.mParent = parent;
        this.mPrefix = prefix;
        this.mLocalName = localName;
        this.mURI = uri;
        this.mNsMapping = parent.mNsMapping;
        this.mNsMapShared = this.mNsMapping != null;
        this.mDefaultNsURI = parent.mDefaultNsURI;
        this.mRootNsContext = parent.mRootNsContext;
        this.mDefaultNsSet = false;
    }

    public static SimpleOutputElement createRoot() {
        return new SimpleOutputElement();
    }

    protected SimpleOutputElement createChild(String localName) {
        this.mAttrMap = null;
        return new SimpleOutputElement(this, null, localName, this.mDefaultNsURI, this.mNsMapping);
    }

    protected SimpleOutputElement reuseAsChild(SimpleOutputElement parent, String localName) {
        this.mAttrMap = null;
        SimpleOutputElement poolHead = this.mParent;
        this.relink(parent, null, localName, this.mDefaultNsURI);
        return poolHead;
    }

    protected SimpleOutputElement reuseAsChild(SimpleOutputElement parent, String prefix, String localName, String uri) {
        this.mAttrMap = null;
        SimpleOutputElement poolHead = this.mParent;
        this.relink(parent, prefix, localName, uri);
        return poolHead;
    }

    protected SimpleOutputElement createChild(String prefix, String localName, String uri) {
        this.mAttrMap = null;
        return new SimpleOutputElement(this, prefix, localName, uri, this.mNsMapping);
    }

    protected void setRootNsContext(NamespaceContext ctxt) {
        String defURI;
        this.mRootNsContext = ctxt;
        if (!this.mDefaultNsSet && (defURI = ctxt.getNamespaceURI("")) != null && defURI.length() > 0) {
            this.mDefaultNsURI = defURI;
        }
    }

    protected void addToPool(SimpleOutputElement poolHead) {
        this.mParent = poolHead;
    }

    public SimpleOutputElement getParent() {
        return this.mParent;
    }

    public boolean isRoot() {
        return this.mParent == null;
    }

    public String getNameDesc() {
        if (this.mPrefix != null && this.mPrefix.length() > 0) {
            return this.mPrefix + ":" + this.mLocalName;
        }
        if (this.mLocalName != null && this.mLocalName.length() > 0) {
            return this.mLocalName;
        }
        return "#error";
    }

    public String getPrefix() {
        return this.mPrefix;
    }

    public String getLocalName() {
        return this.mLocalName;
    }

    public String getNamespaceURI() {
        return this.mURI;
    }

    public String getDefaultNsUri() {
        return this.mDefaultNsURI;
    }

    public QName getName() {
        return QNameCreator.create(this.mURI, this.mLocalName, this.mPrefix);
    }

    public String getExplicitPrefix(String uri) {
        String prefix;
        if (this.mNsMapping != null && (prefix = this.mNsMapping.findPrefixByUri(uri)) != null) {
            return prefix;
        }
        if (this.mRootNsContext != null && (prefix = this.mRootNsContext.getPrefix(uri)) != null && prefix.length() > 0) {
            return prefix;
        }
        return null;
    }

    public int isPrefixValid(String prefix, String nsURI, boolean isElement) throws XMLStreamException {
        if (nsURI == null) {
            nsURI = "";
        }
        if (prefix == null || prefix.length() == 0) {
            if (isElement ? nsURI == this.mDefaultNsURI || nsURI.equals(this.mDefaultNsURI) : nsURI.length() == 0) {
                return 1;
            }
            return 2;
        }
        if (prefix.equals(sXmlNsPrefix)) {
            if (!nsURI.equals(sXmlNsURI)) {
                this.throwOutputError("Namespace prefix 'xml' can not be bound to non-default namespace ('" + nsURI + "'); has to be the default '" + sXmlNsURI + "'");
            }
            return 1;
        }
        String act = this.mNsMapping != null ? this.mNsMapping.findUriByPrefix(prefix) : null;
        if (act == null && this.mRootNsContext != null) {
            act = this.mRootNsContext.getNamespaceURI(prefix);
        }
        if (act == null) {
            return 0;
        }
        return act == nsURI || act.equals(nsURI) ? 1 : 2;
    }

    public void checkAttrWrite(String nsURI, String localName, String value) throws XMLStreamException {
        AttrName an = new AttrName(nsURI, localName);
        if (this.mAttrMap == null) {
            this.mAttrMap = new HashMap();
            this.mAttrMap.put(an, value);
        } else {
            String old = this.mAttrMap.put(an, value);
            if (old != null) {
                throw new XMLStreamException("Duplicate attribute write for attribute '" + an + "' (previous value '" + old + "', new value '" + value + "').");
            }
        }
    }

    public void setDefaultNsUri(String uri) {
        this.mDefaultNsURI = uri;
        this.mDefaultNsSet = true;
    }

    public void setPrefix(String prefix) {
        this.mPrefix = prefix;
    }

    public String generateMapping(String prefixBase, String uri, int[] seqArr) {
        if (this.mNsMapping == null) {
            this.mNsMapping = BijectiveNsMap.createEmpty();
        } else if (this.mNsMapShared) {
            this.mNsMapping = this.mNsMapping.createChild();
            this.mNsMapShared = false;
        }
        return this.mNsMapping.addGeneratedMapping(prefixBase, this.mRootNsContext, uri, seqArr);
    }

    public void addPrefix(String prefix, String uri) {
        if (this.mNsMapping == null) {
            this.mNsMapping = BijectiveNsMap.createEmpty();
        } else if (this.mNsMapShared) {
            this.mNsMapping = this.mNsMapping.createChild();
            this.mNsMapShared = false;
        }
        this.mNsMapping.addMapping(prefix, uri);
    }

    public String getNamespaceURI(String prefix) {
        String uri;
        if (prefix.length() == 0) {
            return this.mDefaultNsURI;
        }
        if (this.mNsMapping != null && (uri = this.mNsMapping.findUriByPrefix(prefix)) != null) {
            return uri;
        }
        return this.mRootNsContext != null ? this.mRootNsContext.getNamespaceURI(prefix) : null;
    }

    public String getPrefix(String uri) {
        String prefix;
        if (this.mDefaultNsURI.equals(uri)) {
            return "";
        }
        if (this.mNsMapping != null && (prefix = this.mNsMapping.findPrefixByUri(uri)) != null) {
            return prefix;
        }
        return this.mRootNsContext != null ? this.mRootNsContext.getPrefix(uri) : null;
    }

    public Iterator getPrefixes(String uri) {
        List<String> l = null;
        if (this.mDefaultNsURI.equals(uri)) {
            l = new ArrayList<String>();
            l.add("");
        }
        if (this.mNsMapping != null) {
            l = this.mNsMapping.getPrefixesBoundToUri(uri, l);
        }
        if (this.mRootNsContext != null) {
            Iterator<String> it = this.mRootNsContext.getPrefixes(uri);
            while (it.hasNext()) {
                String prefix = it.next();
                if (prefix.length() == 0) continue;
                if (l == null) {
                    l = new ArrayList();
                } else if (l.contains(prefix)) continue;
                l.add(prefix);
            }
        }
        return l == null ? EmptyIterator.getInstance() : l.iterator();
    }

    private void throwOutputError(String msg) throws XMLStreamException {
        throw new XMLStreamException(msg);
    }

    static final class AttrName
    implements Comparable {
        final String mNsURI;
        final String mLocalName;
        final int mHashCode;

        public AttrName(String nsURI, String localName) {
            this.mNsURI = nsURI == null ? "" : nsURI;
            this.mLocalName = localName;
            this.mHashCode = this.mNsURI.hashCode() * 31 ^ this.mLocalName.hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AttrName)) {
                return false;
            }
            AttrName other = (AttrName)o;
            String otherLN = other.mLocalName;
            if (otherLN != this.mLocalName && !otherLN.equals(this.mLocalName)) {
                return false;
            }
            String otherURI = other.mNsURI;
            return otherURI == this.mNsURI || otherURI.equals(this.mNsURI);
        }

        public String toString() {
            if (this.mNsURI.length() > 0) {
                return "{" + this.mNsURI + "} " + this.mLocalName;
            }
            return this.mLocalName;
        }

        public int hashCode() {
            return this.mHashCode;
        }

        public int compareTo(Object o) {
            AttrName other = (AttrName)o;
            int result = this.mNsURI.compareTo(other.mNsURI);
            if (result == 0) {
                result = this.mLocalName.compareTo(other.mLocalName);
            }
            return result;
        }
    }
}

