/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.transport.network.mina;

import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.CloseFuture;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.WriteFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.andes.transport.Sender;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinaSender
implements Sender<java.nio.ByteBuffer> {
    private static final Logger _log = LoggerFactory.getLogger(MinaSender.class);
    private final IoSession _session;
    private WriteFuture _lastWrite;

    public MinaSender(IoSession session) {
        this._session = session;
    }

    @Override
    public synchronized void send(java.nio.ByteBuffer msg) {
        _log.debug("sending data:");
        ByteBuffer mina = ByteBuffer.allocate(msg.limit());
        mina.put(msg);
        mina.flip();
        this._lastWrite = this._session.write(mina);
        _log.debug("sent data:");
    }

    @Override
    public synchronized void flush() {
        if (this._lastWrite != null) {
            this._lastWrite.join();
        }
    }

    @Override
    public void close() {
        this.flush();
        CloseFuture closed = this._session.close();
        closed.join();
    }

    @Override
    public void setIdleTimeout(int i) {
    }
}

