/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.transport;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.wso2.andes.transport.Method;
import org.wso2.andes.transport.MethodDelegate;
import org.wso2.andes.transport.Option;
import org.wso2.andes.transport.codec.Decoder;
import org.wso2.andes.transport.codec.Encoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConnectionOpen
extends Method {
    public static final int TYPE = 263;
    private short packing_flags = 0;
    private String virtualHost;
    private List<Object> capabilities;

    @Override
    public final int getStructType() {
        return 263;
    }

    @Override
    public final int getSizeWidth() {
        return 0;
    }

    @Override
    public final int getPackWidth() {
        return 2;
    }

    @Override
    public final boolean hasPayload() {
        return false;
    }

    @Override
    public final byte getEncodedTrack() {
        return 0;
    }

    @Override
    public final boolean isConnectionControl() {
        return true;
    }

    public ConnectionOpen() {
    }

    public ConnectionOpen(String virtualHost, List<Object> capabilities, Option ... _options) {
        if (virtualHost != null) {
            this.setVirtualHost(virtualHost);
        }
        if (capabilities != null) {
            this.setCapabilities(capabilities);
        }
        block7: for (int i = 0; i < _options.length; ++i) {
            switch (_options[i]) {
                case INSIST: {
                    this.packing_flags = (short)(this.packing_flags | 0x400);
                    continue block7;
                }
                case SYNC: {
                    this.setSync(true);
                    continue block7;
                }
                case BATCH: {
                    this.setBatch(true);
                    continue block7;
                }
                case UNRELIABLE: {
                    this.setUnreliable(true);
                    continue block7;
                }
                case NONE: {
                    continue block7;
                }
                default: {
                    throw new IllegalArgumentException("invalid option: " + (Object)((Object)_options[i]));
                }
            }
        }
    }

    @Override
    public <C> void dispatch(C context, MethodDelegate<C> delegate) {
        delegate.connectionOpen(context, this);
    }

    public final boolean hasVirtualHost() {
        return (this.packing_flags & 0x100) != 0;
    }

    public final ConnectionOpen clearVirtualHost() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFEFF);
        this.virtualHost = null;
        this.dirty = true;
        return this;
    }

    public final String getVirtualHost() {
        return this.virtualHost;
    }

    public final ConnectionOpen setVirtualHost(String value) {
        this.virtualHost = value;
        this.packing_flags = (short)(this.packing_flags | 0x100);
        this.dirty = true;
        return this;
    }

    public final ConnectionOpen virtualHost(String value) {
        return this.setVirtualHost(value);
    }

    public final boolean hasCapabilities() {
        return (this.packing_flags & 0x200) != 0;
    }

    public final ConnectionOpen clearCapabilities() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFDFF);
        this.capabilities = null;
        this.dirty = true;
        return this;
    }

    public final List<Object> getCapabilities() {
        return this.capabilities;
    }

    public final ConnectionOpen setCapabilities(List<Object> value) {
        this.capabilities = value;
        this.packing_flags = (short)(this.packing_flags | 0x200);
        this.dirty = true;
        return this;
    }

    public final ConnectionOpen capabilities(List<Object> value) {
        return this.setCapabilities(value);
    }

    public final boolean hasInsist() {
        return (this.packing_flags & 0x400) != 0;
    }

    public final ConnectionOpen clearInsist() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFBFF);
        this.dirty = true;
        return this;
    }

    public final boolean getInsist() {
        return this.hasInsist();
    }

    public final ConnectionOpen setInsist(boolean value) {
        this.packing_flags = value ? (short)(this.packing_flags | 0x400) : (short)(this.packing_flags & 0xFFFFFBFF);
        this.dirty = true;
        return this;
    }

    public final ConnectionOpen insist(boolean value) {
        return this.setInsist(value);
    }

    @Override
    public void write(Encoder enc) {
        enc.writeUint16(this.packing_flags);
        if ((this.packing_flags & 0x100) != 0) {
            enc.writeStr8(this.virtualHost);
        }
        if ((this.packing_flags & 0x200) != 0) {
            enc.writeArray(this.capabilities);
        }
    }

    @Override
    public void read(Decoder dec) {
        this.packing_flags = (short)dec.readUint16();
        if ((this.packing_flags & 0x100) != 0) {
            this.virtualHost = dec.readStr8();
        }
        if ((this.packing_flags & 0x200) != 0) {
            this.capabilities = dec.readArray();
        }
    }

    @Override
    public Map<String, Object> getFields() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if ((this.packing_flags & 0x100) != 0) {
            result.put("virtualHost", this.getVirtualHost());
        }
        if ((this.packing_flags & 0x200) != 0) {
            result.put("capabilities", this.getCapabilities());
        }
        if ((this.packing_flags & 0x400) != 0) {
            result.put("insist", this.getInsist());
        }
        return result;
    }
}

