/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.internal;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.http.HttpService;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.ServerRestartHandler;
import org.wso2.carbon.core.ServerShutdownHandler;
import org.wso2.carbon.core.ServerStartupHandler;
import org.wso2.carbon.core.init.CarbonServerManager;
import org.wso2.carbon.core.internal.CarbonCoreDataHolder;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.core.service.RealmService;

public class CarbonCoreServiceComponent {
    private static Log log = LogFactory.getLog(CarbonCoreServiceComponent.class);
    private CarbonCoreDataHolder dataHolder = CarbonCoreDataHolder.getInstance();
    private static List<ServerShutdownHandler> shutdownHandlers = new ArrayList<ServerShutdownHandler>();
    private static List<ServerRestartHandler> restartHandlers = new ArrayList<ServerRestartHandler>();
    private static List<ServerStartupHandler> startupHandlers = new ArrayList<ServerStartupHandler>();
    private static boolean serverStarted;
    private CarbonServerManager carbonServerManager;

    protected void activate(ComponentContext ctxt) {
        try {
            PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            carbonContext.setTenantDomain("carbon.super");
            carbonContext.setTenantId(-1234);
            this.carbonServerManager = new CarbonServerManager();
            this.carbonServerManager.start(ctxt.getBundleContext());
        }
        catch (Throwable e) {
            log.error((Object)"Failed to activate Carbon Core bundle ", e);
        }
    }

    protected void deactivate(ComponentContext ctxt) {
        try {
            this.carbonServerManager.stop();
        }
        catch (Throwable e) {
            log.error((Object)"Failed clean up Carbon core", e);
        }
        try {
            if ("false".equals(this.dataHolder.getServerConfigurationService().getFirstProperty("RequireCarbonServlet"))) {
                return;
            }
        }
        catch (Exception e) {
            log.debug((Object)"Error while retrieving serverConfiguration instance", (Throwable)e);
        }
        serverStarted = false;
        log.debug((Object)"Carbon Core bundle is deactivated ");
    }

    protected void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        this.dataHolder.setServerConfigurationService(serverConfigurationService);
    }

    protected void unsetServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        this.dataHolder.setServerConfigurationService(null);
    }

    protected void setRealmService(RealmService realmService) {
        this.dataHolder.setRealmService(realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
        this.dataHolder.setRealmService(null);
    }

    protected void setHttpService(HttpService httpService) {
        this.dataHolder.setHttpService(httpService);
    }

    protected void unsetHttpService(HttpService httpService) {
        this.dataHolder.setHttpService(null);
    }

    protected void setRegistryService(RegistryService registryService) {
        this.dataHolder.setRegistryService(registryService);
    }

    protected void unsetRegistryService(RegistryService registryService) {
        this.dataHolder.setRegistryService(null);
    }

    protected void addServerShutdownHandler(ServerShutdownHandler shutdownHandler) {
        shutdownHandlers.add(shutdownHandler);
    }

    protected void removeServerShutdownHandler(ServerShutdownHandler shutdownHandler) {
        shutdownHandlers.remove(shutdownHandler);
    }

    protected void addServerRestartHandler(ServerRestartHandler restartHandler) {
        restartHandlers.add(restartHandler);
    }

    protected void removeServerRestartHandler(ServerRestartHandler restartHandler) {
        restartHandlers.remove(restartHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addServerStartupHandler(ServerStartupHandler startupHandler) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (serverStarted) {
                startupHandler.invoke();
            } else {
                startupHandlers.add(startupHandler);
            }
        }
    }

    protected void removeServerStartupHandler(ServerStartupHandler startupHandler) {
        startupHandlers.remove(startupHandler);
    }

    public static void shutdown() {
        for (ServerShutdownHandler shutdownHandler : shutdownHandlers) {
            shutdownHandler.invoke();
        }
    }

    public static void restart() {
        for (ServerRestartHandler restartHandler : restartHandlers) {
            restartHandler.invoke();
        }
    }

    public static synchronized void startup() {
        for (ServerStartupHandler startupHandler : startupHandlers) {
            startupHandler.invoke();
        }
        startupHandlers.clear();
        serverStarted = true;
    }
}

