/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.init;

import java.io.File;
import java.lang.management.ManagementPermission;
import java.net.SocketException;
import java.security.Policy;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.clustering.ClusteringAgent;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.ListenerManager;
import org.apache.axis2.transport.base.threads.ThreadCleanup;
import org.apache.axis2.transport.base.threads.ThreadCleanupContainer;
import org.apache.axis2.util.Utils;
import org.apache.commons.collections.BidiMap;
import org.apache.commons.collections.bidimap.TreeBidiMap;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.adaptor.EclipseStarter;
import org.eclipse.equinox.http.helper.FilterServletAdaptor;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.wso2.carbon.base.CarbonContextHolderBase;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.CarbonAxisConfigurator;
import org.wso2.carbon.core.CarbonConfigurationContextFactory;
import org.wso2.carbon.core.CarbonThreadCleanup;
import org.wso2.carbon.core.ServerInitializer;
import org.wso2.carbon.core.ServerManagement;
import org.wso2.carbon.core.ServerStatus;
import org.wso2.carbon.core.deployment.OSGiAxis2ServiceDeployer;
import org.wso2.carbon.core.deployment.RegistryBasedRepositoryUpdater;
import org.wso2.carbon.core.init.JMXServerManager;
import org.wso2.carbon.core.init.OSGiAxis2ServicesListener;
import org.wso2.carbon.core.init.PreAxis2ConfigItemListener;
import org.wso2.carbon.core.init.PreAxis2RequiredServiceListener;
import org.wso2.carbon.core.internal.CarbonCoreDataHolder;
import org.wso2.carbon.core.internal.CarbonCoreServiceComponent;
import org.wso2.carbon.core.internal.HTTPGetProcessorListener;
import org.wso2.carbon.core.multitenancy.GenericArtifactUnloader;
import org.wso2.carbon.core.multitenancy.MultitenantServerManager;
import org.wso2.carbon.core.multitenancy.utils.TenantAxisUtils;
import org.wso2.carbon.core.security.CarbonJMXAuthenticator;
import org.wso2.carbon.core.transports.CarbonServlet;
import org.wso2.carbon.core.transports.TransportPersistenceManager;
import org.wso2.carbon.core.util.HouseKeepingTask;
import org.wso2.carbon.core.util.ParameterUtil;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.Axis2ConfigItemHolder;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.ConfigurationContextService;
import org.wso2.carbon.utils.Controllable;
import org.wso2.carbon.utils.FileManipulator;
import org.wso2.carbon.utils.MBeanRegistrar;
import org.wso2.carbon.utils.NetworkUtils;
import org.wso2.carbon.utils.ServerException;
import org.wso2.carbon.utils.deployment.Axis2ServiceRegistry;
import org.wso2.carbon.utils.deployment.GhostDeployerUtils;

public final class CarbonServerManager
implements Controllable {
    private static Log log = LogFactory.getLog(CarbonServerManager.class);
    private final Map<String, String> pendingItemMap = new ConcurrentHashMap<String, String>();
    private BundleContext bundleContext;
    private PreAxis2ConfigItemListener configItemListener;
    private PreAxis2RequiredServiceListener requiredServiceListener;
    private OSGiAxis2ServicesListener osgiAxis2ServicesListener;
    private Timer timer = new Timer();
    private static final String CLIENT_REPOSITORY_LOCATION = "Axis2Config.ClientRepositoryLocation";
    private static final String CLIENT_AXIS2_XML_LOCATION = "Axis2Config.clientAxis2XmlLocation";
    private static final String SERVICE_PATH = "service-path";
    private static final String BUNDLE_CONTEXT_ROOT = "bundleContext-root";
    private static final String HOST_NAME = "host-name";
    protected String serverName;
    private String carbonHome;
    private ServerConfigurationService serverConfig;
    private Thread shutdownHook;
    public boolean isEmbedEnv = false;
    public String serverWorkDir;
    public String axis2RepoLocation;
    private ConfigurationContext serverConfigContext;
    private ConfigurationContext clientConfigContext;
    private volatile boolean isShutdownTriggeredByShutdownHook = false;
    private MultitenantServerManager multitenantServerManager;
    private final Object pendingItemsLock = new Object();
    private GenericArtifactUnloader genericArtifactUnloader = new GenericArtifactUnloader();
    private static final ScheduledExecutorService artifactsCleanupExec = Executors.newScheduledThreadPool(1);

    public void start(BundleContext context) {
        SecurityManager secMan = System.getSecurityManager();
        if (secMan != null) {
            secMan.checkPermission(new ManagementPermission("control"));
            new Timer("JavaSecPolicyUpdateTimer").scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    Policy.getPolicy().refresh();
                }
            }, 120000L, 5000L);
        }
        if (System.getProperty("wso2carbon.start.time") == null) {
            System.setProperty("wso2carbon.start.time", System.currentTimeMillis() + "");
        }
        this.bundleContext = context;
        this.configItemListener = new PreAxis2ConfigItemListener(this.bundleContext, this);
        this.requiredServiceListener = new PreAxis2RequiredServiceListener(this.bundleContext, this);
        this.osgiAxis2ServicesListener = new OSGiAxis2ServicesListener(this.bundleContext, this);
        this.populateListeners();
        if (this.configItemListener.registerBundleListener()) {
            this.configItemListener.start();
        }
        if (this.requiredServiceListener.registerServiceListener()) {
            this.requiredServiceListener.start();
        }
        if (this.osgiAxis2ServicesListener.registerBundleListener()) {
            this.osgiAxis2ServicesListener.start();
        }
        if (this.pendingItemMap.isEmpty()) {
            this.initializeCarbon();
        } else {
            this.timer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    try {
                        if (!CarbonServerManager.this.pendingItemMap.isEmpty()) {
                            log.warn((Object)"Carbon initialization is delayed due to the following unsatisfied items:");
                            for (String configItem : CarbonServerManager.this.pendingItemMap.keySet()) {
                                log.warn((Object)("Waiting for required " + (String)CarbonServerManager.this.pendingItemMap.get(configItem) + ": " + configItem));
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }, 60000L, 60000L);
        }
    }

    public void populateListeners() {
        for (Bundle bundle : this.bundleContext.getBundles()) {
            Enumeration entries;
            Dictionary headers = bundle.getHeaders();
            String value = (String)headers.get("Axis2Deployer");
            if (value != null) {
                this.configItemListener.addDeployerBundle(value, bundle);
            }
            if ((value = (String)headers.get("Axis2Module")) != null) {
                this.configItemListener.addModuleBundle(value, bundle);
            }
            if ((entries = bundle.findEntries("META-INF", "*services.xml", true)) != null && entries.hasMoreElements()) {
                this.osgiAxis2ServicesListener.addOSGiAxis2Service(bundle);
            }
            if ((value = (String)headers.get("Axis2RequiredServices")) == null) continue;
            this.requiredServiceListener.addRequiredServiceBundle(bundle, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addPendingItem(String requiredItemName, String itemType) {
        Object object = this.pendingItemsLock;
        synchronized (object) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Pending Item added : " + requiredItemName));
            }
            this.pendingItemMap.put(requiredItemName, itemType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removePendingItem(String requiredItemName) {
        Object object = this.pendingItemsLock;
        synchronized (object) {
            if (this.pendingItemMap.containsKey(requiredItemName)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Pending Item removed : " + requiredItemName));
                }
                this.pendingItemMap.remove(requiredItemName);
                if (this.pendingItemMap.isEmpty()) {
                    this.initializeCarbon();
                }
            }
        }
    }

    private void initializeCarbon() {
        System.getProperties().remove("javax.xml.soap.MessageFactory");
        System.getProperties().remove("javax.xml.soap.SOAPConnectionFactory");
        this.configItemListener.unregisterBundleListener();
        this.requiredServiceListener.unregisterServiceListener();
        this.osgiAxis2ServicesListener.unregisterBundleListener();
        this.timer.cancel();
        try {
            String isMeteringEnabledStr;
            ListenerManager listenerManager;
            String temp;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Starting Carbon initialization...");
            }
            ThreadCleanupContainer.addThreadCleanup((ThreadCleanup)new CarbonThreadCleanup());
            String webLocation = System.getProperty("web.location");
            if (webLocation == null) {
                webLocation = System.getProperty("carbon.home") + File.separator + "repository" + File.separator + "deployment" + File.separator + "server" + File.separator + "webapps" + File.separator + "wservices";
            }
            if ((temp = System.getProperty("wso2.server.standalone")) != null) {
                temp = temp.trim();
                this.isEmbedEnv = temp.equals("true");
            } else {
                this.isEmbedEnv = false;
            }
            this.serverConfig = CarbonCoreDataHolder.getInstance().getServerConfigurationService();
            this.carbonHome = System.getProperty("carbon.home");
            if (this.carbonHome == null) {
                String msg = "carbon.homeSystem property has not been set.";
                log.fatal((Object)msg);
                log.fatal((Object)(this.serverName + " startup failed."));
                throw new ServletException(msg);
            }
            try {
                System.setProperty("carbon.local.ip", NetworkUtils.getLocalHostname());
            }
            catch (SocketException ignored) {
                // empty catch block
            }
            String serverURL = this.serverConfig.getFirstProperty("ServerURL");
            serverURL = org.wso2.carbon.core.util.Utils.replaceSystemProperty(serverURL);
            this.serverConfig.overrideConfigurationProperty("ServerURL", serverURL);
            this.serverName = this.serverConfig.getFirstProperty("Name");
            String hostName = this.serverConfig.getFirstProperty("ClusteringHostName");
            if (System.getProperty("axis2.local.ip.address") == null && hostName != null && hostName.trim().length() != 0) {
                System.setProperty("axis2.local.ip.address", hostName);
            }
            if (System.getProperty("bind.address") == null) {
                System.setProperty("bind.address", hostName != null && hostName.trim().length() != 0 ? hostName.trim() : NetworkUtils.getLocalHostname());
            }
            this.serverWorkDir = new File(this.serverConfig.getFirstProperty("WorkDirectory")).getAbsolutePath();
            System.setProperty("axis2.work.dir", this.serverWorkDir);
            this.setAxis2RepoLocation();
            Axis2ConfigItemHolder configItemHolder = new Axis2ConfigItemHolder();
            configItemHolder.setDeployerBundles(this.configItemListener.getDeployerBundles());
            configItemHolder.setModuleBundles(this.configItemListener.getModuleBundles());
            String carbonContextRoot = this.serverConfig.getFirstProperty("WebContextRoot");
            CarbonAxisConfigurator carbonAxisConfigurator = new CarbonAxisConfigurator();
            carbonAxisConfigurator.setAxis2ConfigItemHolder(configItemHolder);
            carbonAxisConfigurator.setBundleContext(this.bundleContext);
            carbonAxisConfigurator.setCarbonContextRoot(carbonContextRoot);
            if (!carbonAxisConfigurator.isInitialized()) {
                carbonAxisConfigurator.init(this.axis2RepoLocation, webLocation);
            }
            long start = System.currentTimeMillis();
            if (log.isDebugEnabled()) {
                log.debug((Object)"Creating super-tenant Axis2 ConfigurationContext");
            }
            this.serverConfigContext = CarbonConfigurationContextFactory.createNewConfigurationContext(carbonAxisConfigurator, this.bundleContext);
            long end = System.currentTimeMillis();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Completed super-tenant Axis2 ConfigurationContext creation in " + (double)(end - start) / 1000.0 + " sec"));
            }
            if ((listenerManager = this.serverConfigContext.getListenerManager()) == null) {
                listenerManager = new ListenerManager();
                listenerManager.init(this.serverConfigContext);
            }
            this.serverConfigContext.setContextRoot(carbonContextRoot);
            TenantAxisUtils.getTenantConfigurationContexts(this.serverConfigContext);
            carbonAxisConfigurator.addAxis2ConfigServiceListener();
            this.initNetworkUtils(this.serverConfigContext.getAxisConfiguration());
            Parameter enableHttp = new Parameter("enableHTTP", (Object)"true");
            AxisConfiguration axisConfig = this.serverConfigContext.getAxisConfiguration();
            axisConfig.addParameter(enableHttp);
            new TransportPersistenceManager(axisConfig).updateEnabledTransports(axisConfig.getTransportsIn().values(), axisConfig.getTransportsOut().values());
            this.runInitializers();
            this.populateConnectionProperties();
            this.serverConfigContext.setProperty("ContainerManaged", (Object)"true");
            this.serverConfigContext.setProperty("WORK_DIR", (Object)this.serverWorkDir);
            this.serverConfigContext.setProperty("local_WSO2_WSAS", (Object)this);
            this.multitenantServerManager = new MultitenantServerManager();
            this.multitenantServerManager.start(this.serverConfigContext);
            ServerConfigurationService config = CarbonCoreDataHolder.getInstance().getServerConfigurationService();
            String type = config.getFirstProperty("Security.TrustStore.Type");
            String password = config.getFirstProperty("Security.TrustStore.Password");
            String storeFile = new File(config.getFirstProperty("Security.TrustStore.Location")).getAbsolutePath();
            System.setProperty("javax.net.ssl.trustStore", storeFile);
            System.setProperty("javax.net.ssl.trustStoreType", type);
            System.setProperty("javax.net.ssl.trustStorePassword", password);
            this.addShutdownHook();
            this.registerHouseKeepingTask(this.serverConfigContext);
            this.clientConfigContext = this.getClientConfigurationContext();
            TreeBidiMap property = new TreeBidiMap();
            this.clientConfigContext.setProperty("file.resource.map", (Object)property);
            this.clientConfigContext.setContextRoot(carbonContextRoot);
            if (!CarbonUtils.isOptimized()) {
                Axis2ServiceRegistry serviceRegistry = new Axis2ServiceRegistry(this.serverConfigContext);
                serviceRegistry.register(this.bundleContext.getBundles());
                new OSGiAxis2ServiceDeployer(this.serverConfigContext, this.bundleContext).registerBundleListener();
            }
            HttpService httpService = CarbonCoreDataHolder.getInstance().getHttpService();
            HttpContext defaultHttpContext = httpService.createDefaultHttpContext();
            this.registerCarbonServlet(httpService, defaultHttpContext);
            RealmService realmService = CarbonCoreDataHolder.getInstance().getRealmService();
            UserRealm teannt0Realm = realmService.getBootstrapRealm();
            CarbonJMXAuthenticator.setUserRealm(teannt0Realm);
            log.info((Object)("Repository       : " + this.axis2RepoLocation));
            if (CarbonUtils.useRegistryBasedRepository()) {
                log.info((Object)"Using registry based repository");
                UserRegistry userRegistry = CarbonCoreDataHolder.getInstance().getRegistryService().getLocalRepository();
                RegistryBasedRepositoryUpdater.scheduleAtFixedRate(userRegistry, "/repository/deployment/server", this.axis2RepoLocation, 0L, 10L);
            }
            if (GhostDeployerUtils.isGhostOn()) {
                artifactsCleanupExec.scheduleAtFixedRate(this.genericArtifactUnloader, 60L, 60L, TimeUnit.SECONDS);
            }
            if ((isMeteringEnabledStr = this.serverConfig.getFirstProperty("EnableMetering")) != null) {
                System.setProperty("metering.enabled", isMeteringEnabledStr);
            } else {
                System.setProperty("metering.enabled", "false");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Registering ConfigurationContextService...");
            }
            this.bundleContext.registerService(ConfigurationContextService.class.getName(), (Object)new ConfigurationContextService(this.serverConfigContext, this.clientConfigContext), null);
        }
        catch (Throwable e) {
            log.fatal((Object)"WSO2 Carbon initialization Failed", e);
        }
    }

    private void registerCarbonServlet(HttpService httpService, HttpContext defaultHttpContext) throws ServletException, NamespaceException, InvalidSyntaxException {
        if (!"false".equals(this.serverConfig.getFirstProperty("RequireCarbonServlet"))) {
            ServiceReference filterServiceReference;
            CarbonServlet carbonServlet = new CarbonServlet(this.serverConfigContext);
            String servicePath = "/services";
            String path = this.serverConfigContext.getServicePath();
            if (path != null) {
                servicePath = path.trim();
            }
            if (!servicePath.startsWith("/")) {
                servicePath = "/" + servicePath;
            }
            if ((filterServiceReference = this.bundleContext.getServiceReference(Filter.class.getName())) != null) {
                Filter filter = (Filter)this.bundleContext.getService(filterServiceReference);
                httpService.registerServlet(servicePath, (Servlet)new FilterServletAdaptor(filter, null, (Servlet)carbonServlet), null, defaultHttpContext);
            } else {
                httpService.registerServlet(servicePath, (Servlet)carbonServlet, null, defaultHttpContext);
            }
            HTTPGetProcessorListener getProcessorListener = new HTTPGetProcessorListener(carbonServlet, this.bundleContext);
            ServiceReference[] getRequestProcessors = this.bundleContext.getServiceReferences((String)null, "(org.wso2.carbon.osgi.httpGetRequestProcessorService=*)");
            if (getRequestProcessors != null) {
                for (ServiceReference getRequestProcessor : getRequestProcessors) {
                    getProcessorListener.addHTTPGetRequestProcessor(getRequestProcessor, 1);
                }
            }
            this.bundleContext.addServiceListener((ServiceListener)getProcessorListener, "(org.wso2.carbon.osgi.httpGetRequestProcessorService=*)");
        }
    }

    private ConfigurationContext getClientConfigurationContext() throws AxisFault {
        String clientRepositoryLocation = this.serverConfig.getFirstProperty(CLIENT_REPOSITORY_LOCATION);
        String clientAxis2XmlLocationn = this.serverConfig.getFirstProperty(CLIENT_AXIS2_XML_LOCATION);
        ConfigurationContext clientConfigContextToReturn = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)clientRepositoryLocation, (String)clientAxis2XmlLocationn);
        MultiThreadedHttpConnectionManager httpConnectionManager = new MultiThreadedHttpConnectionManager();
        HttpConnectionManagerParams params = new HttpConnectionManagerParams();
        int defaultMaxConnPerHost = 500;
        Parameter defaultMaxConnPerHostParam = clientConfigContextToReturn.getAxisConfiguration().getParameter("defaultMaxConnPerHost");
        if (defaultMaxConnPerHostParam != null) {
            defaultMaxConnPerHost = Integer.parseInt((String)defaultMaxConnPerHostParam.getValue());
        }
        params.setDefaultMaxConnectionsPerHost(defaultMaxConnPerHost);
        int maxTotalConnections = 15000;
        Parameter maxTotalConnectionsParam = clientConfigContextToReturn.getAxisConfiguration().getParameter("maxTotalConnections");
        if (maxTotalConnectionsParam != null) {
            maxTotalConnections = Integer.parseInt((String)maxTotalConnectionsParam.getValue());
        }
        params.setMaxTotalConnections(maxTotalConnections);
        params.setSoTimeout(600000);
        params.setConnectionTimeout(600000);
        httpConnectionManager.setParams(params);
        clientConfigContextToReturn.setProperty("MULTITHREAD_HTTP_CONNECTION_MANAGER", (Object)httpConnectionManager);
        this.registerHouseKeepingTask(clientConfigContextToReturn);
        clientConfigContextToReturn.setProperty("WORK_DIR", (Object)this.serverWorkDir);
        return clientConfigContextToReturn;
    }

    private void setAxis2RepoLocation() {
        if (System.getProperty("axis2.repo") != null) {
            this.axis2RepoLocation = System.getProperty("axis2.repo");
            if (CarbonUtils.isMultipleInstanceCase() && !CarbonUtils.isChildNode()) {
                this.axis2RepoLocation = CarbonUtils.getCarbonHome();
            }
            this.serverConfig.setConfigurationProperty("Axis2Config.RepositoryLocation", this.axis2RepoLocation);
        } else {
            this.axis2RepoLocation = this.serverConfig.getFirstProperty("Axis2Config.RepositoryLocation");
        }
        if (!this.axis2RepoLocation.endsWith("/")) {
            this.serverConfig.setConfigurationProperty("Axis2Config.RepositoryLocation", this.axis2RepoLocation + "/");
            this.axis2RepoLocation = this.axis2RepoLocation + "/";
        }
    }

    private void populateConnectionProperties() throws Exception {
        Resource resource;
        RegistryService registryService = CarbonCoreDataHolder.getInstance().getRegistryService();
        UserRegistry registry = registryService.getConfigSystemRegistry();
        String contextRoot = this.serverConfigContext.getContextRoot();
        String servicePath = this.serverConfigContext.getServicePath();
        String requestIP = Utils.getIpAddress((AxisConfiguration)this.serverConfigContext.getAxisConfiguration());
        if (!registry.resourceExists("/repository/connection/props")) {
            resource = registry.newResource();
            resource.setProperty(SERVICE_PATH, servicePath);
            resource.setProperty(BUNDLE_CONTEXT_ROOT, contextRoot);
            resource.setProperty(HOST_NAME, requestIP);
            registry.put("/repository/connection/props", resource);
        } else {
            resource = registry.get("/repository/connection/props");
            String exServicePath = resource.getProperty(SERVICE_PATH);
            String exContext = resource.getProperty(BUNDLE_CONTEXT_ROOT);
            String exHost = resource.getProperty(HOST_NAME);
            if (!(exServicePath != null && exServicePath.equals(servicePath) && exContext != null && exContext.equals(contextRoot) && exHost != null && exHost.equals(contextRoot))) {
                resource.setProperty(SERVICE_PATH, servicePath);
                resource.setProperty(BUNDLE_CONTEXT_ROOT, contextRoot);
                resource.setProperty(HOST_NAME, requestIP);
                registry.put("/repository/connection/props", resource);
            }
        }
        resource.discard();
    }

    private void registerHouseKeepingTask(ConfigurationContext configurationContext) {
        if (Boolean.valueOf(this.serverConfig.getFirstProperty("HouseKeeping.AutoStart")).booleanValue()) {
            Timer houseKeepingTimer = new Timer();
            long houseKeepingInterval = Long.parseLong(this.serverConfig.getFirstProperty("HouseKeeping.Interval")) * 60L * 1000L;
            Object property = configurationContext.getProperty("file.resource.map");
            if (property == null) {
                property = new TreeBidiMap();
                configurationContext.setProperty("file.resource.map", property);
            }
            houseKeepingTimer.scheduleAtFixedRate((TimerTask)new HouseKeepingTask(this.serverWorkDir, (BidiMap)property), houseKeepingInterval, houseKeepingInterval);
        }
    }

    private void runInitializers() throws ServerException {
        String[] initializers;
        for (String clazzName : initializers = this.serverConfig.getProperties("ServerInitializers.Initializer")) {
            try {
                Class clazz = this.bundleContext.getBundle().loadClass(clazzName);
                ServerInitializer intializer = (ServerInitializer)clazz.newInstance();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Using ServerInitializer " + intializer.getClass().getName()));
                }
                intializer.init(this.serverConfigContext);
            }
            catch (Exception e) {
                throw new ServerException((Throwable)e);
            }
        }
    }

    private void initNetworkUtils(AxisConfiguration axisConfiguration) throws AxisFault, SocketException {
        String hostName = this.serverConfig.getFirstProperty("HostName");
        String mgtHostName = this.serverConfig.getFirstProperty("MgtHostName");
        if (hostName != null) {
            Parameter param = axisConfiguration.getParameter("hostname");
            if (param != null) {
                param.setEditable(true);
                param.setValue((Object)hostName);
            } else {
                param = ParameterUtil.createParameter("hostname", hostName);
                axisConfiguration.addParameter(param);
            }
        } else {
            Parameter param = axisConfiguration.getParameter("hostname");
            if (param != null) {
                hostName = (String)param.getValue();
                log.info((Object)"hostname has been selected from Axis2.xml.");
            }
        }
        NetworkUtils.init((String)hostName, (String)mgtHostName);
    }

    public void restart() {
        this.restart(false);
    }

    public void restartGracefully() {
        this.restart(true);
    }

    private void restart(boolean isGraceful) {
        this.createSuperTenantCarbonContext();
        SecurityManager secMan = System.getSecurityManager();
        if (secMan != null) {
            secMan.checkPermission(new ManagementPermission("control"));
        }
        Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
        new JMXServerManager().stopJmxService();
        try {
            ServerStatus.setServerRestarting();
            HashMap inTransports = this.serverConfigContext.getAxisConfiguration().getTransportsIn();
            if (isGraceful) {
                log.info((Object)("Gracefully restarting " + this.serverName + "..."));
                new ServerManagement(inTransports, this.serverConfigContext).startMaintenanceForShutDown();
            } else {
                log.info((Object)("Restarting " + this.serverName + "..."));
            }
            try {
                ServerStatus.setServerRestarting();
            }
            catch (AxisFault e) {
                String msg = "Cannot set server to restarting mode";
                log.error((Object)msg, (Throwable)e);
            }
            MBeanRegistrar.unregisterAllMBeans();
            CarbonContextHolderBase.unloadTenant((int)-1234);
            ClusteringAgent clusteringAgent = this.serverConfigContext.getAxisConfiguration().getClusteringAgent();
            if (clusteringAgent != null) {
                clusteringAgent.stop();
            }
            if (!CarbonUtils.isRunningInStandaloneMode()) {
                long waitFor = 5L;
                log.info((Object)("Waiting for " + waitFor + " sec before initiating restart"));
                Thread.sleep(waitFor * 1000L);
            }
            new Thread(new Runnable(){

                @Override
                public void run() {
                    log.info((Object)"Starting a new Carbon instance. Current instance will be shutdown");
                    log.info((Object)"Halting JVM");
                    System.exit(121);
                }
            }).start();
        }
        catch (Exception e) {
            String msg = "Cannot set server to restarting mode";
            log.error((Object)msg, (Throwable)e);
        }
    }

    private void createSuperTenantCarbonContext() {
        PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        carbonContext.setTenantId(-1234);
        carbonContext.setTenantDomain("carbon.super");
    }

    public void shutdown() {
        block7: {
            this.createSuperTenantCarbonContext();
            SecurityManager secMan = System.getSecurityManager();
            if (secMan != null) {
                secMan.checkPermission(new ManagementPermission("control"));
            }
            log.info((Object)("Shutting down " + this.serverName + "..."));
            if (!this.isShutdownTriggeredByShutdownHook) {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
            try {
                try {
                    ServerStatus.setServerShuttingDown();
                }
                catch (AxisFault e) {
                    String msg = "Cannot set server to shutdown mode";
                    log.error((Object)msg, (Throwable)e);
                }
                CarbonCoreServiceComponent.shutdown();
                new JMXServerManager().stopJmxService();
                log.info((Object)"Shutting down OSGi framework...");
                EclipseStarter.shutdown();
                log.info((Object)"Shutdown complete");
                log.info((Object)"Halting JVM");
                if (!this.isShutdownTriggeredByShutdownHook) {
                    System.exit(0);
                }
            }
            catch (Exception e) {
                log.error((Object)("Error occurred while shutting down " + this.serverName), (Throwable)e);
                if (this.isShutdownTriggeredByShutdownHook) break block7;
                System.exit(1);
            }
        }
    }

    public void shutdownGracefully() {
        String msg;
        this.createSuperTenantCarbonContext();
        try {
            ServerStatus.setServerShuttingDown();
        }
        catch (Exception e) {
            msg = "Cannot set server to shutdown mode";
            log.error((Object)msg, (Throwable)e);
        }
        try {
            log.info((Object)("Gracefully shutting down " + this.serverName + "..."));
            HashMap inTransports = this.serverConfigContext.getAxisConfiguration().getTransportsIn();
            new ServerManagement(inTransports, this.serverConfigContext).startMaintenanceForShutDown();
        }
        catch (Exception e) {
            msg = "Cannot put transports into maintenance mode";
            log.error((Object)msg, (Throwable)e);
        }
        this.shutdown();
    }

    private void addShutdownHook() {
        if (this.shutdownHook != null) {
            return;
        }
        this.shutdownHook = new Thread(){

            @Override
            public void run() {
                log.info((Object)"Shutdown hook triggered....");
                CarbonServerManager.this.isShutdownTriggeredByShutdownHook = true;
                CarbonServerManager.this.shutdownGracefully();
            }
        };
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    public void stop() throws Exception {
        log.info((Object)"Stopping CarbonServerManager...");
        FileManipulator.deleteDir((File)new File(this.carbonHome + File.separator + this.serverConfig.getFirstProperty("WorkDirectory")));
        if (this.serverConfigContext != null) {
            Object property = this.serverConfigContext.getProperty("file.resource.map");
            if (property != null) {
                ((Map)property).clear();
            }
            String servicePath = "/services";
            String path = this.serverConfigContext.getServicePath();
            if (path != null) {
                servicePath = path.trim();
            }
            if (!servicePath.startsWith("/")) {
                servicePath = "/" + servicePath;
            }
            try {
                CarbonCoreDataHolder.getInstance().getHttpService().unregister(servicePath);
            }
            catch (Exception e) {
                log.error((Object)"Failed to Un-register Servlets ", (Throwable)e);
            }
        }
        MBeanRegistrar.unregisterAllMBeans();
        this.configItemListener = null;
        this.osgiAxis2ServicesListener = null;
        this.requiredServiceListener = null;
        this.shutdownHook = null;
        CarbonConfigurationContextFactory.clear();
        this.multitenantServerManager.cleanup();
        if (CarbonUtils.useRegistryBasedRepository()) {
            RegistryBasedRepositoryUpdater.cleanup();
        }
        if (this.serverConfigContext != null) {
            this.serverConfigContext.removeProperty("local_WSO2_WSAS");
            this.serverConfigContext.removeProperty("primaryBundleContext");
            this.serverConfigContext.terminate();
        }
        if (this.clientConfigContext != null) {
            this.clientConfigContext.terminate();
        }
        this.serverConfigContext = null;
        this.clientConfigContext = null;
        artifactsCleanupExec.shutdownNow();
    }
}

