/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core;

import java.util.HashMap;
import java.util.Map;

public class ResourcePath {
    private static final String VERSION_PARAMETER_NAME = "version";
    private String completePath;
    private String path;
    private boolean currentVersion = true;
    private Map<String, String> parameters = new HashMap<String, String>();

    public ResourcePath(String rawPath) {
        this.completePath = rawPath;
        if (!this.completePath.startsWith("/")) {
            this.completePath = "/" + this.completePath;
        }
        String[] parts = this.completePath.split(";");
        this.path = parts[0];
        if (!this.path.equals("/") && this.path.endsWith("/")) {
            this.path = this.path.substring(0, this.path.length() - "/".length());
        }
        for (int i = 1; i < parts.length; ++i) {
            String[] paramParts = parts[i].split(":");
            String key = paramParts[0];
            if (paramParts.length > 1) {
                StringBuilder sb = new StringBuilder(paramParts[1]);
                for (int j = 2; j < paramParts.length; ++j) {
                    sb.append(":").append(paramParts[j]);
                }
                this.parameters.put(key, sb.toString());
            } else {
                this.parameters.put(key, null);
            }
            if (!VERSION_PARAMETER_NAME.equals(key)) continue;
            this.currentVersion = false;
        }
    }

    public String getCompletePath() {
        return this.completePath;
    }

    public String getPath() {
        return this.path;
    }

    public boolean parameterExists(String key) {
        return this.parameters.containsKey(key);
    }

    public String getParameterValue(String key) {
        return this.parameters.get(key);
    }

    public void setParameter(String key, String value) {
        this.parameters.put(key, value);
        this.completePath = this.path + this.getParameterPath();
    }

    public void appendPath(String pathToAppend) {
        if (pathToAppend == null || pathToAppend.length() == 0) {
            return;
        }
        if (pathToAppend.startsWith("/")) {
            pathToAppend = pathToAppend.substring("/".length());
        }
        if (!this.path.endsWith("/")) {
            this.path = this.path + "/";
        }
        this.path = this.path + pathToAppend;
        this.completePath = this.path + this.getParameterPath();
    }

    public boolean isCurrentVersion() {
        return this.currentVersion;
    }

    public String getPathWithVersion() {
        if (this.isCurrentVersion()) {
            return this.getPath();
        }
        String versionString = this.getParameterValue(VERSION_PARAMETER_NAME);
        if (versionString != null) {
            return this.getPath() + ";" + VERSION_PARAMETER_NAME + ":" + versionString;
        }
        return this.getPath();
    }

    public String toString() {
        return this.completePath;
    }

    private String getParameterPath() {
        StringBuilder paramPath = new StringBuilder();
        for (Map.Entry<String, String> e : this.parameters.entrySet()) {
            paramPath.append(";").append(e.getKey()).append(":").append(e.getValue());
            if (!VERSION_PARAMETER_NAME.equals(e.getKey())) continue;
            this.currentVersion = false;
        }
        return paramPath.toString();
    }
}

