/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.agent;

import java.util.Collection;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.workgroup.packet.AgentInfo;
import org.jivesoftware.smackx.workgroup.packet.AgentWorkgroups;

public class Agent {
    private XMPPConnection connection;
    private String workgroupJID;

    public static Collection getWorkgroups(String serviceJID, String agentJID, XMPPConnection connection) throws XMPPException {
        AgentWorkgroups request = new AgentWorkgroups(agentJID);
        request.setTo(serviceJID);
        PacketCollector collector = connection.createPacketCollector((PacketFilter)new PacketIDFilter(request.getPacketID()));
        connection.sendPacket((Packet)request);
        AgentWorkgroups response = (AgentWorkgroups)collector.nextResult((long)SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (response == null) {
            throw new XMPPException("No response from server on status set.");
        }
        if (response.getError() != null) {
            throw new XMPPException(response.getError());
        }
        return response.getWorkgroups();
    }

    Agent(XMPPConnection connection, String workgroupJID) {
        this.connection = connection;
        this.workgroupJID = workgroupJID;
    }

    public String getUser() {
        return this.connection.getUser();
    }

    public String getName() throws XMPPException {
        AgentInfo agentInfo = new AgentInfo();
        agentInfo.setType(IQ.Type.GET);
        agentInfo.setTo(this.workgroupJID);
        agentInfo.setFrom(this.getUser());
        PacketCollector collector = this.connection.createPacketCollector((PacketFilter)new PacketIDFilter(agentInfo.getPacketID()));
        this.connection.sendPacket((Packet)agentInfo);
        AgentInfo response = (AgentInfo)collector.nextResult((long)SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (response == null) {
            throw new XMPPException("No response from server on status set.");
        }
        if (response.getError() != null) {
            throw new XMPPException(response.getError());
        }
        return response.getName();
    }

    public void setName(String newName) throws XMPPException {
        AgentInfo agentInfo = new AgentInfo();
        agentInfo.setType(IQ.Type.SET);
        agentInfo.setTo(this.workgroupJID);
        agentInfo.setFrom(this.getUser());
        agentInfo.setName(newName);
        PacketCollector collector = this.connection.createPacketCollector((PacketFilter)new PacketIDFilter(agentInfo.getPacketID()));
        this.connection.sendPacket((Packet)agentInfo);
        IQ response = (IQ)collector.nextResult((long)SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (response == null) {
            throw new XMPPException("No response from server on status set.");
        }
        if (response.getError() != null) {
            throw new XMPPException(response.getError());
        }
    }
}

